/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.BlockTrackEvent;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiBlockTrackOptions;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.GuiKeybindCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderBlockTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.SearchUpgradeHandler;
import me.desht.pneumaticcraft.common.config.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.recipes.CraftingRegistrator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlockTrackUpgradeHandler
implements IUpgradeRenderHandler {
    static final int BLOCK_TRACKING_RANGE = 30;
    private static final int HARD_MAX_BLOCKS_PER_TICK = 50000;
    private final Map<BlockPos, RenderBlockTarget> blockTargets = new HashMap<BlockPos, RenderBlockTarget>();
    private GuiAnimatedStat blockTrackInfo;
    private final Map<String, Integer> blockTypeCount = new HashMap<String, Integer>();
    private final Map<String, Integer> blockTypeCountPartial = new HashMap<String, Integer>();
    private int xOff = 0;
    private int yOff = 0;
    private int zOff = 0;
    private RenderBlockTarget focusedTarget = null;
    private EnumFacing focusedFace = null;

    @Override
    public String getUpgradeName() {
        return "blockTracker";
    }

    @Override
    public void update(EntityPlayer player, int rangeUpgrades) {
        SearchUpgradeHandler searchHandler = HUDHandler.instance().getSpecificRenderer(SearchUpgradeHandler.class);
        int blockTrackRange = 30 + Math.min(rangeUpgrades, 5) * 5;
        long now = System.nanoTime();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 50000 && ((i & 0xFF) != 0 || System.nanoTime() - now <= (long)(ConfigHandler.client.blockTrackerMaxTimePerTick * 500000)); ++i) {
            List<IBlockTrackEntry> entries;
            this.nextScanPos(pos, player, blockTrackRange);
            if (!player.field_70170_p.func_175667_e((BlockPos)pos)) break;
            TileEntity te = player.field_70170_p.func_175625_s((BlockPos)pos);
            if (MinecraftForge.EVENT_BUS.post((Event)new BlockTrackEvent(player.field_70170_p, (BlockPos)pos, te))) continue;
            if (searchHandler != null && te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                searchHandler.checkInventoryForItems(te, null, GuiKeybindCheckBox.isHandlerEnabled(searchHandler));
            }
            if ((entries = BlockTrackEntryList.instance.getEntriesForCoordinate((IBlockAccess)player.field_70170_p, (BlockPos)pos, te)).isEmpty()) continue;
            entries.forEach(entry -> {
                String k = entry.getEntryName();
                this.blockTypeCountPartial.put(k, this.blockTypeCountPartial.getOrDefault(k, 0) + 1);
            });
            RenderBlockTarget blockTarget = this.blockTargets.get(pos);
            if (blockTarget != null) {
                blockTarget.ticksExisted = Math.abs(blockTarget.ticksExisted);
                blockTarget.setTileEntity(te);
                continue;
            }
            RenderBlockTarget target = this.addBlockTarget(new RenderBlockTarget(player.field_70170_p, player, pos.func_185334_h(), te, this));
            target.maybeRefreshFromServer(entries);
        }
        this.checkBlockFocus(player, blockTrackRange);
        this.processTrackerEntries(player, blockTrackRange);
        this.updateTrackerText();
    }

    private void checkBlockFocus(EntityPlayer player, int blockTrackRange) {
        Vec3d eyes;
        this.focusedTarget = null;
        this.focusedFace = null;
        Vec3d v = eyes = player.func_174824_e(1.0f);
        Vec3d lookVec = player.func_70040_Z();
        for (int i = 0; i < blockTrackRange * 4; ++i) {
            IBlockState state;
            RayTraceResult rtr;
            v = v.func_178787_e(lookVec.func_186678_a(0.25));
            BlockPos checkPos = new BlockPos(v.field_72450_a, v.field_72448_b, v.field_72449_c);
            if (!this.blockTargets.containsKey(checkPos) || (rtr = (state = player.field_70170_p.func_180495_p(checkPos)).func_185900_c((IBlockAccess)player.field_70170_p, checkPos).func_186670_a(checkPos).func_72327_a(eyes, v)) == null || rtr.field_72313_a != RayTraceResult.Type.BLOCK) continue;
            this.focusedTarget = this.blockTargets.get(checkPos);
            this.focusedFace = rtr.field_178784_b;
            break;
        }
    }

    public RenderBlockTarget getFocusedTarget() {
        return this.focusedTarget;
    }

    public BlockPos getFocusedPos() {
        return this.focusedTarget == null ? null : this.focusedTarget.getPos();
    }

    public EnumFacing getFocusedFace() {
        return this.focusedFace;
    }

    private void nextScanPos(BlockPos.MutableBlockPos pos, EntityPlayer player, int range) {
        EnumFacing dir = PneumaticCraftUtils.getDirectionFacing((EntityLivingBase)player, true);
        switch (dir) {
            case UP: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (++this.yOff <= range) break;
                this.yOff = 0;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case DOWN: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (--this.yOff >= -range) break;
                this.yOff = 0;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case EAST: {
                if (++this.xOff <= range) break;
                this.xOff = 0;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case WEST: {
                if (--this.xOff >= -range) break;
                this.xOff = 0;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case NORTH: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (--this.zOff >= -range) break;
                this.zOff = 0;
                this.updateBlockTypeCounts();
                break;
            }
            case SOUTH: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (++this.zOff <= range) break;
                this.zOff = 0;
                this.updateBlockTypeCounts();
            }
        }
        pos.func_189532_c(player.field_70165_t + (double)this.xOff, MathHelper.func_151237_a((double)(player.field_70163_u + (double)this.yOff), (double)0.0, (double)255.0), player.field_70161_v + (double)this.zOff);
    }

    private void updateBlockTypeCounts() {
        this.blockTypeCount.clear();
        this.blockTypeCountPartial.forEach(this.blockTypeCount::put);
        this.blockTypeCountPartial.clear();
    }

    private void processTrackerEntries(EntityPlayer player, int blockTrackRange) {
        ArrayList<RenderBlockTarget> toRemove = new ArrayList<RenderBlockTarget>();
        for (RenderBlockTarget blockTarget : this.blockTargets.values()) {
            boolean wasNegative = blockTarget.ticksExisted < 0;
            blockTarget.ticksExisted += CommonArmorHandler.getHandlerForPlayer(player).getSpeedFromUpgrades(EntityEquipmentSlot.HEAD);
            if (blockTarget.ticksExisted >= 0 && wasNegative) {
                blockTarget.ticksExisted = -1;
            }
            blockTarget.update();
            if (!(blockTarget.getDistanceToEntity((Entity)player) > (double)(blockTrackRange + 5)) && blockTarget.isTargetStillValid()) continue;
            if (blockTarget.ticksExisted > 0) {
                blockTarget.ticksExisted = -60;
                continue;
            }
            if (blockTarget.ticksExisted != -1) continue;
            toRemove.add(blockTarget);
        }
        toRemove.forEach(this::removeBlockTarget);
    }

    private void updateTrackerText() {
        ArrayList<String> textList = new ArrayList<String>();
        if (this.focusedTarget != null) {
            this.blockTrackInfo.setTitle(this.focusedTarget.stat.getTitle());
            textList.addAll(this.focusedTarget.textList);
        } else {
            this.blockTrackInfo.setTitle("Current tracked blocks:");
            this.blockTypeCount.forEach((k, v) -> {
                if (v > 0 && GuiKeybindCheckBox.fromKeyBindingName((String)k).checked) {
                    textList.add(v + " " + I18n.func_135052_a((String)k, (Object[])new Object[0]));
                }
            });
            if (textList.size() == 0) {
                textList.add("Tracking no blocks currently.");
            }
        }
        this.blockTrackInfo.setText(textList);
    }

    private RenderBlockTarget addBlockTarget(RenderBlockTarget blockTarget) {
        this.blockTargets.put(blockTarget.getPos(), blockTarget);
        return blockTarget;
    }

    private void removeBlockTarget(RenderBlockTarget blockTarget) {
        this.blockTargets.remove(blockTarget.getPos());
    }

    public int countBlockTrackersOfType(IBlockTrackEntry type) {
        return this.blockTypeCount.getOrDefault(type.getEntryName(), 0);
    }

    @Override
    public void render3D(float partialTicks) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        this.blockTargets.values().forEach(t -> t.render(partialTicks));
        GlStateManager.func_179089_o();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    @Override
    public void render2D(float partialTicks, boolean helmetEnabled) {
    }

    @Override
    public Item[] getRequiredUpgrades() {
        return new Item[]{Itemss.upgrades.get(IItemRegistry.EnumUpgrade.BLOCK_TRACKER)};
    }

    @Override
    public void reset() {
        this.blockTypeCountPartial.clear();
        this.blockTypeCount.clear();
        this.blockTrackInfo = null;
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 1.0f * (1.0f + (float)Math.min(5, rangeUpgrades) * 5.0f / 30.0f) * (float)CommonArmorHandler.getHandlerForPlayer(player).getSpeedFromUpgrades(EntityEquipmentSlot.HEAD);
    }

    @Override
    public IOptionPage getGuiOptionsPage() {
        return new GuiBlockTrackOptions(this);
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot() {
        return EntityEquipmentSlot.HEAD;
    }

    @Override
    public GuiAnimatedStat getAnimatedStat() {
        if (this.blockTrackInfo == null) {
            GuiAnimatedStat.StatIcon icon = GuiAnimatedStat.StatIcon.of(CraftingRegistrator.getUpgrade(IItemRegistry.EnumUpgrade.BLOCK_TRACKER));
            this.blockTrackInfo = new GuiAnimatedStat(null, "Current tracked blocks:", icon, 0x3000AA00, null, ArmorHUDLayout.INSTANCE.blockTrackerStat);
            this.blockTrackInfo.setMinDimensionsAndReset(0, 0);
        }
        return this.blockTrackInfo;
    }

    public void hack() {
        for (RenderBlockTarget target : this.blockTargets.values()) {
            target.hack();
        }
    }

    public RenderBlockTarget getTargetForCoord(BlockPos pos) {
        return this.blockTargets.get(pos);
    }

    public boolean scroll(MouseEvent event) {
        for (RenderBlockTarget target : this.blockTargets.values()) {
            if (!target.scroll(event)) continue;
            this.getAnimatedStat().handleMouseWheel(event.getDwheel());
            return true;
        }
        return false;
    }

    @Override
    public void onResolutionChanged() {
        this.blockTrackInfo = null;
    }
}

