/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftModeled;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.TOPCallback;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.PropertyObject;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Optional;
import team.chisel.ctm.api.IFacade;

@Optional.Interface(iface="team.chisel.ctm.api.IFacade", modid="ctm-api")
public abstract class BlockPneumaticCraftCamo
extends BlockPneumaticCraftModeled
implements IFacade {
    public static final PropertyObject<IBlockState> CAMO_STATE = new PropertyObject<IBlockState>("camo_state", IBlockState.class);
    public static final PropertyObject<IBlockAccess> BLOCK_ACCESS = new PropertyObject<IBlockAccess>("block_access", IBlockAccess.class);
    public static final PropertyObject<BlockPos> BLOCK_POS = new PropertyObject<BlockPos>("pos", BlockPos.class);
    static final IUnlistedProperty[] UNLISTED_CAMO_PROPERTIES = new IUnlistedProperty[]{CAMO_STATE, BLOCK_ACCESS, BLOCK_POS};

    protected BlockPneumaticCraftCamo(Material par2Material, String registryName) {
        super(par2Material, registryName);
    }

    protected boolean doesCamoOverrideBounds() {
        return true;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] iPropertyArray;
        if (this.isRotatable()) {
            IProperty[] iPropertyArray2 = new IProperty[1];
            iPropertyArray = iPropertyArray2;
            iPropertyArray2[0] = ROTATION;
        } else {
            iPropertyArray = new IProperty[]{};
        }
        IProperty[] props = iPropertyArray;
        return new ExtendedBlockState((Block)this, props, UNLISTED_CAMO_PROPERTIES);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState camoState;
        TileEntity te = PneumaticCraftUtils.getTileEntitySafely(world, pos);
        if (te instanceof ICamouflageableTE && (camoState = ((ICamouflageableTE)te).getCamouflage()) != null) {
            return ((IExtendedBlockState)state).withProperty(BLOCK_ACCESS, (Object)world).withProperty(BLOCK_POS, (Object)pos).withProperty(CAMO_STATE, (Object)camoState);
        }
        return state;
    }

    @Override
    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        IBlockState camoState;
        if (te instanceof ICamouflageableTE && !player.func_184812_l_() && (camoState = ((ICamouflageableTE)te).getCamouflage()) != null) {
            ItemStack camoStack = ICamouflageableTE.getStackForState(camoState);
            EntityItem entity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, camoStack);
            world.func_72838_d((Entity)entity);
            ((ICamouflageableTE)te).setCamouflage(null);
            return;
        }
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState camo = this.getCamoState(source, pos);
        return camo != null && this.doesCamoOverrideBounds() ? camo.func_185900_c(source, pos) : super.func_185496_a(state, source, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        IBlockState camo = this.getCamoState(worldIn, pos);
        return camo != null ? camo.func_185890_d(worldIn, pos) : super.func_180646_a(blockState, worldIn, pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        IBlockState camo = this.getCamoState((IBlockAccess)worldIn, pos);
        if (camo != null) {
            BlockPneumaticCraftCamo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)camo.func_185900_c((IBlockAccess)worldIn, pos));
        } else {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
        }
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState camo = this.getCamoState(world, pos);
        return camo == null ? super.doesSideBlockRendering(state, world, pos, face) : camo.doesSideBlockRendering(world, pos, face);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState camo = this.getCamoState(world, pos);
        return camo == null ? super.isSideSolid(base_state, world, pos, side) : camo.isSideSolid(world, pos, side);
    }

    protected IBlockState getCamoState(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity te = PneumaticCraftUtils.getTileEntitySafely(blockAccess, pos);
        if (!(te instanceof ICamouflageableTE)) {
            return null;
        }
        IBlockState camoState = ((ICamouflageableTE)te).getCamouflage();
        return camoState == null || camoState.func_177230_c() instanceof BlockPneumaticCraftCamo ? null : camoState;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        IBlockState camoState = this.getCamoState(worldIn, pos);
        return camoState != null ? camoState.func_193401_d(worldIn, pos, face) : BlockFaceShape.UNDEFINED;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        IBlockState camo = this.getCamoState((IBlockAccess)world, data.getPos());
        if (camo != null) {
            TOPCallback.handleCamo(mode, probeInfo, camo);
        }
    }

    @Nonnull
    @Optional.Method(modid="ctm-api")
    public IBlockState getFacade(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ICamouflageableTE && ((ICamouflageableTE)te).getCamouflage() != null) {
            return ((ICamouflageableTE)te).getCamouflage();
        }
        return world.func_180495_p(pos);
    }
}

