/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.dataservices.dataproviders;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.configurate.ConfigurateHelper;
import io.github.nucleuspowered.nucleus.configurate.datatypes.ItemDataNode;
import io.github.nucleuspowered.nucleus.configurate.datatypes.KitConfigDataNode;
import io.github.nucleuspowered.nucleus.configurate.datatypes.UserCacheVersionNode;
import io.github.nucleuspowered.nucleus.configurate.loaders.NucleusGsonConfigurationLoader;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.ConfigurateDataProvider;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.DataProvider;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.FileChangingConfigurateDataProvider;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.FileChangingSimpleConfigurateDataProvider;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.SimpleConfigurateDataProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.gson.GsonConfigurationLoader;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;

public class DataProviders {
    private final NucleusPlugin plugin;
    private final TypeToken<Map<String, ItemDataNode>> ttmsi = new TypeToken<Map<String, ItemDataNode>>(){};
    private final TypeToken<Map<String, String>> ttss = new TypeToken<Map<String, String>>(){};
    private final TypeToken<KitConfigDataNode> ttmk = TypeToken.of(KitConfigDataNode.class);
    private final TypeToken<UserCacheVersionNode> ttucv = TypeToken.of(UserCacheVersionNode.class);
    private final String userJson = "userdata%1$s%2$s%1$s%3$s.json";
    private final String worldJson = "worlddata%1$s%2$s%1$s%3$s.json";

    public DataProviders(NucleusPlugin plugin) {
        this.plugin = plugin;
    }

    public DataProvider<ConfigurationNode> getUserFileDataProviders(UUID uuid, boolean create) {
        try {
            Path p = this.getFile(this.userJson, uuid);
            if (create || this.doesUserFileExist(uuid)) {
                return new SimpleConfigurateDataProvider(path -> ((GsonConfigurationLoader.Builder)this.getGsonBuilder().setPath(path)).build(), p, this.plugin.getLogger());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean doesUserFileExist(UUID uuid) {
        try {
            return Files.exists(this.getFile(this.userJson, uuid), new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public DataProvider<ConfigurationNode> getWorldFileDataProvider(UUID uuid, boolean create) {
        try {
            Path p = this.getFile(this.worldJson, uuid);
            if (create || this.doesWorldFileExist(uuid)) {
                return new SimpleConfigurateDataProvider(path -> ((GsonConfigurationLoader.Builder)this.getGsonBuilder().setPath(path)).build(), p, this.plugin.getLogger());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean doesWorldFileExist(UUID uuid) {
        try {
            return Files.exists(this.getFile(this.worldJson, uuid), new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public DataProvider.FileChanging<KitConfigDataNode> getKitsDataProvider() {
        try {
            Supplier<Path> p = () -> this.plugin.getDataPath().resolve("kits.json");
            return new FileChangingConfigurateDataProvider<KitConfigDataNode>(this.ttmk, path -> new LazyConfigurationLoader(() -> new NucleusGsonConfigurationLoader((GsonConfigurationLoader.Builder)this.getGsonBuilder().setPath(path))), p);
        }
        catch (Exception e) {
            return null;
        }
    }

    public DataProvider.FileChanging<UserCacheVersionNode> getUserCacheDataProvider() {
        try {
            Supplier<Path> p = () -> this.plugin.getDataPath().resolve("nucleususercache.json");
            return new FileChangingConfigurateDataProvider<UserCacheVersionNode>(this.ttucv, path -> new LazyConfigurationLoader(() -> ((GsonConfigurationLoader.Builder)this.getGsonBuilder().setPath(path)).build()), p);
        }
        catch (Exception e) {
            return null;
        }
    }

    public DataProvider.FileChanging<ConfigurationNode> getGeneralDataProvider() {
        try {
            Supplier<Path> p = () -> this.plugin.getDataPath().resolve("general.json");
            return new FileChangingSimpleConfigurateDataProvider(path -> new LazyConfigurationLoader(() -> ((GsonConfigurationLoader.Builder)this.getGsonBuilder().setPath(path)).build()), p, this.plugin.getLogger());
        }
        catch (Exception e) {
            return null;
        }
    }

    public DataProvider<Map<String, ItemDataNode>> getItemDataProvider() {
        try {
            Path p = this.plugin.getConfigDirPath().resolve("items.conf");
            return new ConfigurateDataProvider<Map<String, ItemDataNode>>(this.ttmsi, path -> new LazyConfigurationLoader(() -> ((HoconConfigurationLoader.Builder)this.getHoconBuilder().setPath(path)).build()), HashMap::new, p, this.plugin.getLogger());
        }
        catch (Exception e) {
            return null;
        }
    }

    public DataProvider.FileChanging<Map<String, String>> getNameBanDataProvider() {
        try {
            Supplier<Path> p = () -> this.plugin.getDataPath().resolve("namebans.json");
            return new FileChangingConfigurateDataProvider<Map<String, String>>(this.ttss, path -> new LazyConfigurationLoader(() -> ((GsonConfigurationLoader.Builder)this.getGsonBuilder().setPath(path)).build()), HashMap::new, p);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Path getFile(String template, UUID uuid) throws Exception {
        String u = uuid.toString();
        String f = u.substring(0, 2);
        return this.getFile(this.plugin.getDataPath().resolve(String.format(template, File.separator, f, u)));
    }

    private Path getFile(Path file) throws Exception {
        if (Files.notExists(file, new LinkOption[0])) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        return file;
    }

    private GsonConfigurationLoader.Builder getGsonBuilder() {
        GsonConfigurationLoader.Builder gsb = GsonConfigurationLoader.builder();
        return (GsonConfigurationLoader.Builder)gsb.setDefaultOptions(ConfigurateHelper.setOptions(gsb.getDefaultOptions()));
    }

    private HoconConfigurationLoader.Builder getHoconBuilder() {
        HoconConfigurationLoader.Builder gsb = HoconConfigurationLoader.builder();
        return (HoconConfigurationLoader.Builder)gsb.setDefaultOptions(ConfigurateHelper.setOptions(gsb.getDefaultOptions()));
    }

    private static class LazyConfigurationLoader<T extends ConfigurationNode>
    implements ConfigurationLoader<T> {
        private ConfigurationLoader<T> lazyLoad = null;
        private final Supplier<ConfigurationLoader<T>> supplier;

        private LazyConfigurationLoader(Supplier<ConfigurationLoader<T>> supplier) {
            Preconditions.checkNotNull(supplier);
            this.supplier = supplier;
        }

        public ConfigurationOptions getDefaultOptions() {
            this.init();
            return this.lazyLoad.getDefaultOptions();
        }

        public T load(ConfigurationOptions options) throws IOException {
            this.init();
            return (T)this.lazyLoad.load(options);
        }

        public void save(ConfigurationNode node) throws IOException {
            this.init();
            this.lazyLoad.save(node);
        }

        public T createEmptyNode(ConfigurationOptions options) {
            this.init();
            return (T)this.lazyLoad.createEmptyNode(options);
        }

        private void init() {
            if (this.lazyLoad == null) {
                this.lazyLoad = this.supplier.get();
            }
        }
    }
}

