/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.text;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateEventImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;

public class NucleusTextTemplateMessageSender {
    private final NucleusTextTemplate textTemplate;
    private final CommandSource sender;

    public NucleusTextTemplateMessageSender(NucleusTextTemplate textTemplate, CommandSource sender) {
        this.textTemplate = textTemplate;
        this.sender = sender;
    }

    public boolean send(Cause cause) {
        ArrayList members = Lists.newArrayList((Object[])new CommandSource[]{Sponge.getServer().getConsole()});
        members.addAll(Sponge.getServer().getOnlinePlayers());
        return this.send(members, true, cause);
    }

    public boolean send(Collection<CommandSource> source, Cause cause) {
        return this.send(source, false, cause);
    }

    private boolean send(Collection<CommandSource> source, boolean isBroadcast, Cause cause) {
        NucleusTextTemplateEventImpl event = isBroadcast ? new NucleusTextTemplateEventImpl.Broadcast(this.textTemplate, source, cause) : new NucleusTextTemplateEventImpl(this.textTemplate, source, cause);
        if (Sponge.getEventManager().post((Event)event)) {
            return false;
        }
        NucleusTextTemplate template = event.getMessage();
        if (!template.containsTokens()) {
            Text text = this.textTemplate.getForCommandSource((CommandSource)Sponge.getServer().getConsole());
            event.getRecipients().forEach(x -> x.sendMessage(text));
        } else {
            HashMap m = Maps.newHashMap();
            m.put("sender", cs -> Nucleus.getNucleus().getMessageTokenService().applyPrimaryToken("displayname", this.sender));
            event.getRecipients().forEach(x -> x.sendMessage(this.textTemplate.getForCommandSource((CommandSource)x, m, null)));
        }
        return true;
    }
}

