/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.invulnerability.listeners;

import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.modules.invulnerability.services.InvulnerabilityService;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.ai.SetAITargetEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;

public class InvulnerabilityListener
implements ListenerBase {
    private final InvulnerabilityService service = this.getServiceUnchecked(InvulnerabilityService.class);

    @Listener
    public void onSetAITargetEvent(SetAITargetEvent event, @Getter(value="getTarget") Entity entity) {
        if (entity instanceof Player && this.service.isInvulnerable((User)((Player)entity))) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onPlayerStruck(DamageEntityEvent event, @Getter(value="getTargetEntity") Player pl) {
        if (this.service.isInvulnerable((User)pl)) {
            pl.offer(Keys.FIRE_TICKS, (Object)0);
            event.setBaseDamage(0.0);
            event.setCancelled(true);
            event.getCause().allOf(EntityDamageSource.class).forEach(x -> {
                Entity entity = x.getSource();
                if (entity instanceof Agent) {
                    this.disableAI((Agent)entity, pl);
                }
            });
            event.getCause().allOf(Agent.class).forEach(f -> this.disableAI((Agent)f, pl));
        }
    }

    private void disableAI(Agent agent, Player pl) {
        if (agent.getTarget().map(y -> y.equals(pl)).orElse(false).booleanValue()) {
            agent.setTarget(null);
        }
    }

    @Listener
    public void onPlayerQuit(ClientConnectionEvent.Disconnect event) {
        this.service.removeFromCache(event.getTargetEntity().getUniqueId());
    }
}

