/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoHelpSubcommand;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NotifyIfAFK;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RedirectModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.message.services.MessageHandler;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(mainOverride="message", suggestedLevel=SuggestedLevel.USER)
@NoHelpSubcommand
@RedirectModifiers(value="message")
@RegisterCommand(value={"reply", "r"})
@EssentialsEquivalent(value={"r", "reply"})
@NonnullByDefault
@NotifyIfAFK(value={"player"})
public class ReplyCommand
extends AbstractCommand<CommandSource> {
    private final MessageHandler handler = (MessageHandler)this.getServiceUnchecked(MessageHandler.class);

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.MESSAGE};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        boolean b = this.handler.replyMessage(src, (String)args.getOne("message").get());
        if (b) {
            this.handler.getLastMessageFrom(Util.getUUID(src)).ifPresent(x -> args.putArg("player", x));
            return CommandResult.success();
        }
        return CommandResult.empty();
    }
}

