/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nickname.commands;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.NameUtil;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.exceptions.NicknameException;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.nickname.services.NicknameService;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@RegisterCommand(value={"nick", "nickname"})
@Permissions
@EssentialsEquivalent(value={"nick", "nickname"}, isExact=false, notes="To remove a nickname, use '/delnick'")
public class NicknameCommand
extends AbstractCommand<CommandSource> {
    private final NicknameService nicknameService = (NicknameService)this.getServiceUnchecked(NicknameService.class);
    private final String playerKey = "subject";
    private final String nickName = "nickname";
    private final Map<String, String> permissionToDesc = Maps.newHashMap();

    @Override
    protected void afterPostInit() {
        super.afterPostInit();
        MessageProvider mp = Nucleus.getNucleus().getMessageProvider();
        String colPerm = this.permissions.getPermissionWithSuffix("colour.");
        String colPerm2 = this.permissions.getPermissionWithSuffix("color.");
        NameUtil.getColours().forEach((key, value) -> {
            this.permissionToDesc.put(colPerm + value.getName(), mp.getMessageWithFormat("permission.nick.colourspec", value.getName().toLowerCase(), key.toString()));
            this.permissionToDesc.put(colPerm2 + value.getName(), mp.getMessageWithFormat("permission.nick.colorspec", value.getName().toLowerCase(), key.toString()));
        });
        String stylePerm = this.permissions.getPermissionWithSuffix("style.");
        NameUtil.getStyleKeys().entrySet().stream().filter(x -> ((Character)x.getKey()).charValue() != 'k').forEach(k -> this.permissionToDesc.put(stylePerm + ((String)k.getValue()).toLowerCase(), mp.getMessageWithFormat("permission.nick.stylespec", ((String)k.getValue()).toLowerCase(), ((Character)k.getKey()).toString())));
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("others", PermissionInformation.getWithTranslation("permission.nick.others", SuggestedLevel.ADMIN));
        m.put("colour", PermissionInformation.getWithTranslation("permission.nick.colour", SuggestedLevel.ADMIN, true, false));
        m.put("color", PermissionInformation.getWithTranslation("permission.nick.color", SuggestedLevel.ADMIN));
        m.put("color.<color>", PermissionInformation.getWithTranslation("permission.nick.colorsingle", SuggestedLevel.ADMIN, false, true));
        m.put("style", PermissionInformation.getWithTranslation("permission.nick.style", SuggestedLevel.ADMIN));
        m.put("style.<style>", PermissionInformation.getWithTranslation("permission.nick.stylesingle", SuggestedLevel.ADMIN, false, true));
        m.put("magic", PermissionInformation.getWithTranslation("permission.nick.magic", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    protected Map<String, PermissionInformation> permissionsToRegister() {
        return this.permissionToDesc.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> new PermissionInformation((String)v.getValue(), SuggestedLevel.ADMIN, true, false)));
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)this.requirePermissionArg(GenericArguments.onlyOne((CommandElement)GenericArguments.user((Text)Text.of((String)this.playerKey))), this.permissions.getPermissionWithSuffix("others"))), GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)this.nickName)))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        User pl = this.getUserFromArgs(User.class, src, this.playerKey, args);
        Text name = args.getOne(this.nickName).map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).deserialize(arg_0)).get();
        try {
            this.nicknameService.setNick(pl, src, name, false);
        }
        catch (NicknameException e) {
            throw new ReturnMessageException(e.getTextMessage());
        }
        if (!src.equals(pl)) {
            src.sendMessage(Text.builder().append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nick.success.other", pl.getName())}).append(new Text[]{Text.of((Object[])new Object[]{" - ", TextColors.RESET, name})}).build());
        }
        return CommandResult.success();
    }
}

