/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.playerinfo.misc;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.service.NucleusSeenService;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.modules.playerinfo.config.PlayerInfoConfig;
import io.github.nucleuspowered.nucleus.modules.playerinfo.config.PlayerInfoConfigAdapter;
import java.util.Collection;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;

public class BasicSeenInformationProvider
implements NucleusSeenService.SeenInformationProvider,
PermissionTrait {
    private final String permission;
    private final BiFunction<CommandSource, User, Collection<Text>> getterFunction;
    private static PlayerInfoConfigAdapter adapter = null;

    public BasicSeenInformationProvider(@Nullable String permission, BiFunction<CommandSource, User, Collection<Text>> getterFunction) {
        this.permission = permission;
        this.getterFunction = getterFunction;
    }

    @Override
    public boolean hasPermission(@Nonnull CommandSource source, @Nonnull User user) {
        try {
            return this.hasPermission((Subject)source, "nucleus.seen.extended") || this.permission != null && !((PlayerInfoConfig)BasicSeenInformationProvider.getAdapter().getNodeOrDefault()).getSeen().isExtendedPermRequired() && this.hasPermission((Subject)source, this.permission);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    @Nonnull
    public Collection<Text> getInformation(@Nonnull CommandSource source, @Nonnull User user) {
        return this.getterFunction.apply(source, user);
    }

    private static synchronized PlayerInfoConfigAdapter getAdapter() throws Exception {
        if (adapter == null) {
            adapter = Nucleus.getNucleus().getModuleContainer().getConfigAdapterForModule("playerinfo", PlayerInfoConfigAdapter.class);
        }
        return adapter;
    }
}

