/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import java.util.UUID;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@NoModifiers
@Permissions(prefix="world", suggestedLevel=SuggestedLevel.OWNER)
@RegisterCommand(value={"clone", "copy"}, subcommandOf=WorldCommand.class)
public class CloneWorldCommand
extends AbstractCommand<CommandSource> {
    private final String newKey = "new name";

    @Override
    protected CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.WORLD_PROPERTIES_ALL, GenericArguments.string((Text)Text.of((String)this.newKey))};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        Supplier<MessageReceiver> mr;
        WorldProperties worldToCopy = (WorldProperties)args.getOne("world").get();
        String oldName = worldToCopy.getWorldName();
        String newName = (String)args.getOne(this.newKey).get();
        if (Sponge.getServer().getWorldProperties(newName).isPresent()) {
            throw ReturnMessageException.fromKey("command.world.clone.alreadyexists", newName);
        }
        Text message = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.clone.starting", oldName, newName);
        src.sendMessage(message);
        if (!(src instanceof ConsoleSource)) {
            Sponge.getServer().getConsole().sendMessage(message);
        }
        if (src instanceof Player) {
            UUID uuid = ((Player)src).getUniqueId();
            mr = () -> Sponge.getServer().getPlayer(uuid).map(x -> x).orElseGet(() -> new MessageReceiver(){

                public void sendMessage(Text message) {
                }

                public MessageChannel getMessageChannel() {
                    return MessageChannel.TO_NONE;
                }

                public void setMessageChannel(MessageChannel channel) {
                }
            });
        } else {
            mr = () -> src;
        }
        Sponge.getServer().copyWorld(worldToCopy, newName).handle((result, ex) -> {
            MessageReceiver m = (MessageReceiver)mr.get();
            Text msg = ex == null && result.isPresent() ? Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.clone.success", oldName, newName) : Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.clone.failed", oldName, newName);
            m.sendMessage(msg);
            if (!(m instanceof ConsoleSource)) {
                Sponge.getServer().getConsole().sendMessage(msg);
            }
            return result;
        });
        return CommandResult.success();
    }
}

