/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.delegates.manager;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.api.event.cause.CreationCause;
import me.lucko.luckperms.api.event.cause.DeletionCause;
import me.lucko.luckperms.common.api.ApiUtils;
import me.lucko.luckperms.common.api.delegates.manager.ApiAbstractManager;
import me.lucko.luckperms.common.api.delegates.model.ApiTrack;
import me.lucko.luckperms.common.managers.track.TrackManager;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.utils.ImmutableCollectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiTrackManager
extends ApiAbstractManager<Track, me.lucko.luckperms.api.Track, TrackManager<?>>
implements me.lucko.luckperms.api.manager.TrackManager {
    public ApiTrackManager(LuckPermsPlugin plugin, TrackManager<?> handle) {
        super(plugin, handle);
    }

    @Override
    protected me.lucko.luckperms.api.Track getDelegateFor(Track internal) {
        if (internal == null) {
            return null;
        }
        return internal.getApiDelegate();
    }

    @Override
    public @NonNull CompletableFuture<me.lucko.luckperms.api.Track> createAndLoadTrack(@NonNull String name) {
        name = ApiUtils.checkName(Objects.requireNonNull(name, "name"));
        return this.plugin.getStorage().createAndLoadTrack(name, CreationCause.API).thenApply(this::getDelegateFor);
    }

    @Override
    public @NonNull CompletableFuture<Optional<me.lucko.luckperms.api.Track>> loadTrack(@NonNull String name) {
        name = ApiUtils.checkName(Objects.requireNonNull(name, "name"));
        return this.plugin.getStorage().loadTrack(name).thenApply(opt -> opt.map(this::getDelegateFor));
    }

    @Override
    public @NonNull CompletableFuture<Void> saveTrack(@NonNull me.lucko.luckperms.api.Track track) {
        Objects.requireNonNull(track, "track");
        return this.plugin.getStorage().saveTrack(ApiTrack.cast(track));
    }

    @Override
    public @NonNull CompletableFuture<Void> deleteTrack(@NonNull me.lucko.luckperms.api.Track track) {
        Objects.requireNonNull(track, "track");
        return this.plugin.getStorage().deleteTrack(ApiTrack.cast(track), DeletionCause.API);
    }

    @Override
    public @NonNull CompletableFuture<Void> loadAllTracks() {
        return this.plugin.getStorage().loadAllTracks();
    }

    @Override
    public me.lucko.luckperms.api.Track getTrack(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return this.getDelegateFor((Track)((TrackManager)this.handle).getIfLoaded(name));
    }

    @Override
    public @NonNull Set<me.lucko.luckperms.api.Track> getLoadedTracks() {
        return (Set)((TrackManager)this.handle).getAll().values().stream().map(this::getDelegateFor).collect(ImmutableCollectors.toSet());
    }

    @Override
    public boolean isLoaded(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return ((TrackManager)this.handle).isLoaded(name);
    }
}

