/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.delegates.misc;

import java.util.Objects;
import me.lucko.luckperms.api.ChatMetaType;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.NodeFactory;
import me.lucko.luckperms.common.api.delegates.model.ApiGroup;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ApiNodeFactory
implements NodeFactory {
    public static final ApiNodeFactory INSTANCE = new ApiNodeFactory();

    private ApiNodeFactory() {
    }

    @Override
    public @NonNull Node.Builder newBuilder(@NonNull String permission) {
        Objects.requireNonNull(permission, "permission");
        return me.lucko.luckperms.common.node.factory.NodeFactory.builder(permission);
    }

    @Override
    public @NonNull Node.Builder newBuilderFromExisting(@NonNull Node other) {
        return Objects.requireNonNull(other, "other").toBuilder();
    }

    @Override
    public @NonNull Node.Builder makeGroupNode(@NonNull Group group) {
        Objects.requireNonNull(group, "group");
        return me.lucko.luckperms.common.node.factory.NodeFactory.buildGroupNode(ApiGroup.cast(group));
    }

    @Override
    public @NonNull Node.Builder makeGroupNode(@NonNull String groupName) {
        Objects.requireNonNull(groupName, "groupName");
        return me.lucko.luckperms.common.node.factory.NodeFactory.buildGroupNode(groupName);
    }

    @Override
    public @NonNull Node.Builder makeMetaNode(@NonNull String key, @NonNull String value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        return me.lucko.luckperms.common.node.factory.NodeFactory.buildMetaNode(key, value);
    }

    @Override
    public @NonNull Node.Builder makeChatMetaNode(@NonNull ChatMetaType type, int priority, @NonNull String value) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(value, "value");
        return me.lucko.luckperms.common.node.factory.NodeFactory.buildChatMetaNode(type, priority, value);
    }

    @Override
    public @NonNull Node.Builder makePrefixNode(int priority, @NonNull String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        return me.lucko.luckperms.common.node.factory.NodeFactory.buildPrefixNode(priority, prefix);
    }

    @Override
    public @NonNull Node.Builder makeSuffixNode(int priority, @NonNull String suffix) {
        Objects.requireNonNull(suffix, "suffix");
        return me.lucko.luckperms.common.node.factory.NodeFactory.buildSuffixNode(priority, suffix);
    }
}

