/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.LookupSetting;
import me.lucko.luckperms.api.TemporaryMergeBehaviour;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.metastacking.MetaStackDefinition;
import me.lucko.luckperms.common.assignments.AssignmentRule;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.config.ConfigKey;
import me.lucko.luckperms.common.config.ConfigKeyTypes;
import me.lucko.luckperms.common.config.adapter.ConfigurationAdapter;
import me.lucko.luckperms.common.graph.TraversalAlgorithm;
import me.lucko.luckperms.common.metastacking.SimpleMetaStackDefinition;
import me.lucko.luckperms.common.metastacking.StandardStackElements;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.primarygroup.AllParentsByWeightHolder;
import me.lucko.luckperms.common.primarygroup.ParentsByWeightHolder;
import me.lucko.luckperms.common.primarygroup.PrimaryGroupHolder;
import me.lucko.luckperms.common.primarygroup.StoredHolder;
import me.lucko.luckperms.common.storage.implementation.split.SplitStorageType;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.common.utils.ImmutableCollectors;

public final class ConfigKeys {
    public static final ConfigKey<String> SERVER;
    public static final ConfigKey<Integer> SYNC_TIME;
    public static final ConfigKey<EnumSet<LookupSetting>> LOOKUP_SETTINGS;
    public static final ConfigKey<Boolean> USE_SERVER_UUID_CACHE;
    public static final ConfigKey<Boolean> ALLOW_INVALID_USERNAMES;
    public static final ConfigKey<Boolean> DEBUG_LOGINS;
    public static final ConfigKey<Boolean> CANCEL_FAILED_LOGINS;
    public static final ConfigKey<TemporaryMergeBehaviour> TEMPORARY_ADD_BEHAVIOUR;
    public static final ConfigKey<String> PRIMARY_GROUP_CALCULATION_METHOD;
    public static final ConfigKey<Function<User, PrimaryGroupHolder>> PRIMARY_GROUP_CALCULATION;
    public static final ConfigKey<Boolean> PREVENT_PRIMARY_GROUP_REMOVAL;
    public static final ConfigKey<Boolean> USE_ARGUMENT_BASED_COMMAND_PERMISSIONS;
    public static final ConfigKey<Boolean> REQUIRE_SENDER_GROUP_MEMBERSHIP_TO_MODIFY;
    public static final ConfigKey<Boolean> APPLYING_WILDCARDS;
    public static final ConfigKey<Boolean> APPLYING_REGEX;
    public static final ConfigKey<Boolean> APPLYING_SHORTHAND;
    public static final ConfigKey<Boolean> APPLY_BUKKIT_CHILD_PERMISSIONS;
    public static final ConfigKey<Boolean> APPLY_BUKKIT_DEFAULT_PERMISSIONS;
    public static final ConfigKey<Boolean> APPLY_BUKKIT_ATTACHMENT_PERMISSIONS;
    public static final ConfigKey<Boolean> APPLY_NUKKIT_CHILD_PERMISSIONS;
    public static final ConfigKey<Boolean> APPLY_NUKKIT_DEFAULT_PERMISSIONS;
    public static final ConfigKey<Boolean> APPLY_NUKKIT_ATTACHMENT_PERMISSIONS;
    public static final ConfigKey<Boolean> APPLY_BUNGEE_CONFIG_PERMISSIONS;
    public static final ConfigKey<Boolean> APPLY_SPONGE_IMPLICIT_WILDCARDS;
    public static final ConfigKey<Boolean> APPLY_SPONGE_DEFAULT_SUBJECTS;
    public static final ConfigKey<TraversalAlgorithm> INHERITANCE_TRAVERSAL_ALGORITHM;
    public static final ConfigKey<Map<String, Integer>> GROUP_WEIGHTS;
    public static final ConfigKey<MetaStackDefinition> PREFIX_FORMATTING_OPTIONS;
    public static final ConfigKey<MetaStackDefinition> SUFFIX_FORMATTING_OPTIONS;
    public static final ConfigKey<Boolean> LOG_NOTIFY;
    public static final ConfigKey<Boolean> AUTO_OP;
    public static final ConfigKey<Boolean> OPS_ENABLED;
    public static final ConfigKey<Boolean> COMMANDS_ALLOW_OP;
    public static final ConfigKey<Boolean> VAULT_UNSAFE_LOOKUPS;
    public static final ConfigKey<Boolean> USE_VAULT_SERVER;
    public static final ConfigKey<String> VAULT_SERVER;
    public static final ConfigKey<Boolean> VAULT_INCLUDING_GLOBAL;
    public static final ConfigKey<Boolean> VAULT_IGNORE_WORLD;
    public static final ConfigKey<Boolean> VAULT_DEBUG;
    public static final ConfigKey<Map<String, String>> WORLD_REWRITES;
    public static final ConfigKey<Map<String, String>> GROUP_NAME_REWRITES;
    public static final ConfigKey<List<AssignmentRule>> DEFAULT_ASSIGNMENTS;
    public static final ConfigKey<StorageCredentials> DATABASE_VALUES;
    public static final ConfigKey<String> SQL_TABLE_PREFIX;
    public static final ConfigKey<String> MONGODB_COLLECTION_PREFIX;
    public static final ConfigKey<String> MONGODB_CONNECTION_URI;
    public static final ConfigKey<String> STORAGE_METHOD;
    public static final ConfigKey<Boolean> WATCH_FILES;
    public static final ConfigKey<Boolean> SPLIT_STORAGE;
    public static final ConfigKey<Map<SplitStorageType, String>> SPLIT_STORAGE_OPTIONS;
    public static final ConfigKey<String> MESSAGING_SERVICE;
    public static final ConfigKey<Boolean> AUTO_PUSH_UPDATES;
    public static final ConfigKey<Boolean> PUSH_LOG_ENTRIES;
    public static final ConfigKey<Boolean> BROADCAST_RECEIVED_LOG_ENTRIES;
    public static final ConfigKey<Boolean> REDIS_ENABLED;
    public static final ConfigKey<String> REDIS_ADDRESS;
    public static final ConfigKey<String> REDIS_PASSWORD;
    public static final ConfigKey<String> WEB_EDITOR_URL_PATTERN;
    public static final ConfigKey<String> VERBOSE_VIEWER_URL_PATTERN;
    public static final ConfigKey<String> TREE_VIEWER_URL_PATTERN;
    private static final AtomicInteger ORDINAL_COUNTER;
    private static final Map<String, ConfigKey<?>> KEYS;

    public static Map<String, ConfigKey<?>> getKeys() {
        return KEYS;
    }

    public static int size() {
        return ORDINAL_COUNTER.get();
    }

    private ConfigKeys() {
    }

    static {
        Field[] values;
        SERVER = ConfigKeyTypes.customKey(c -> {
            String serverName;
            if (c.getBoolean("use-server-properties-name", false) && (serverName = c.getPlugin().getBootstrap().getServerName()) != null && !serverName.equals("Unknown Server")) {
                return serverName.toLowerCase();
            }
            return c.getString("server", "global").toLowerCase();
        });
        SYNC_TIME = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> {
            int val = c.getInteger("sync-minutes", -1);
            if (val == -1) {
                val = c.getInteger("data.sync-minutes", -1);
            }
            return val;
        }));
        LOOKUP_SETTINGS = ConfigKeyTypes.customKey(c -> EnumSet.copyOf(Contexts.of(ContextSet.empty(), c.getBoolean("include-global", true), c.getBoolean("include-global-world", true), true, c.getBoolean("apply-global-groups", true), c.getBoolean("apply-global-world-groups", true), false).getSettings()));
        USE_SERVER_UUID_CACHE = ConfigKeyTypes.booleanKey("use-server-uuid-cache", false);
        ALLOW_INVALID_USERNAMES = ConfigKeyTypes.booleanKey("allow-invalid-usernames", false);
        DEBUG_LOGINS = ConfigKeyTypes.booleanKey("debug-logins", false);
        CANCEL_FAILED_LOGINS = ConfigKeyTypes.booleanKey("cancel-failed-logins", false);
        TEMPORARY_ADD_BEHAVIOUR = ConfigKeyTypes.customKey(c -> {
            String option = c.getString("temporary-add-behaviour", "deny").toLowerCase();
            if (!(option.equals("deny") || option.equals("replace") || option.equals("accumulate"))) {
                option = "deny";
            }
            return ArgumentParser.parseTemporaryModifier(option);
        });
        PRIMARY_GROUP_CALCULATION_METHOD = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> {
            String option = c.getString("primary-group-calculation", "stored").toLowerCase();
            if (!(option.equals("stored") || option.equals("parents-by-weight") || option.equals("all-parents-by-weight"))) {
                option = "stored";
            }
            return option;
        }));
        PRIMARY_GROUP_CALCULATION = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> {
            String option;
            switch (option = PRIMARY_GROUP_CALCULATION_METHOD.get((ConfigurationAdapter)c)) {
                case "stored": {
                    return StoredHolder::new;
                }
                case "parents-by-weight": {
                    return ParentsByWeightHolder::new;
                }
            }
            return AllParentsByWeightHolder::new;
        }));
        PREVENT_PRIMARY_GROUP_REMOVAL = ConfigKeyTypes.booleanKey("prevent-primary-group-removal", true);
        USE_ARGUMENT_BASED_COMMAND_PERMISSIONS = ConfigKeyTypes.booleanKey("argument-based-command-permissions", false);
        REQUIRE_SENDER_GROUP_MEMBERSHIP_TO_MODIFY = ConfigKeyTypes.booleanKey("require-sender-group-membership-to-modify", false);
        APPLYING_WILDCARDS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-wildcards", true));
        APPLYING_REGEX = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-regex", true));
        APPLYING_SHORTHAND = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-shorthand", true));
        APPLY_BUKKIT_CHILD_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-bukkit-child-permissions", true));
        APPLY_BUKKIT_DEFAULT_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-bukkit-default-permissions", true));
        APPLY_BUKKIT_ATTACHMENT_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-bukkit-attachment-permissions", true));
        APPLY_NUKKIT_CHILD_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-nukkit-child-permissions", true));
        APPLY_NUKKIT_DEFAULT_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-nukkit-default-permissions", true));
        APPLY_NUKKIT_ATTACHMENT_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-nukkit-attachment-permissions", true));
        APPLY_BUNGEE_CONFIG_PERMISSIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-bungee-config-permissions", false));
        APPLY_SPONGE_IMPLICIT_WILDCARDS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-sponge-implicit-wildcards", true));
        APPLY_SPONGE_DEFAULT_SUBJECTS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("apply-sponge-default-subjects", true));
        INHERITANCE_TRAVERSAL_ALGORITHM = ConfigKeyTypes.customKey(c -> {
            String value = c.getString("inheritance-traversal-algorithm", "depth-first-pre-order");
            switch (value.toLowerCase()) {
                case "breadth-first": {
                    return TraversalAlgorithm.BREADTH_FIRST;
                }
                case "depth-first-post-order": {
                    return TraversalAlgorithm.DEPTH_FIRST_POST_ORDER;
                }
            }
            return TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER;
        });
        GROUP_WEIGHTS = ConfigKeyTypes.customKey(c -> (Map)c.getStringMap("group-weight", (Map<String, String>)ImmutableMap.of()).entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((String)e.getKey()).toLowerCase(), e -> {
            try {
                return Integer.parseInt((String)e.getValue());
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        })));
        PREFIX_FORMATTING_OPTIONS = ConfigKeyTypes.customKey(l -> {
            List<String> format = l.getStringList("meta-formatting.prefix.format", new ArrayList<String>());
            if (format.isEmpty()) {
                format.add("highest");
            }
            String startSpacer = l.getString("meta-formatting.prefix.start-spacer", "");
            String middleSpacer = l.getString("meta-formatting.prefix.middle-spacer", " ");
            String endSpacer = l.getString("meta-formatting.prefix.end-spacer", "");
            return new SimpleMetaStackDefinition(StandardStackElements.parseList(l.getPlugin(), format), startSpacer, middleSpacer, endSpacer);
        });
        SUFFIX_FORMATTING_OPTIONS = ConfigKeyTypes.customKey(l -> {
            List<String> format = l.getStringList("meta-formatting.suffix.format", new ArrayList<String>());
            if (format.isEmpty()) {
                format.add("highest");
            }
            String startSpacer = l.getString("meta-formatting.suffix.start-spacer", "");
            String middleSpacer = l.getString("meta-formatting.suffix.middle-spacer", " ");
            String endSpacer = l.getString("meta-formatting.suffix.end-spacer", "");
            return new SimpleMetaStackDefinition(StandardStackElements.parseList(l.getPlugin(), format), startSpacer, middleSpacer, endSpacer);
        });
        LOG_NOTIFY = ConfigKeyTypes.booleanKey("log-notify", true);
        AUTO_OP = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("auto-op", false));
        OPS_ENABLED = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> AUTO_OP.get((ConfigurationAdapter)c) == false && c.getBoolean("enable-ops", true)));
        COMMANDS_ALLOW_OP = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("commands-allow-op", true));
        VAULT_UNSAFE_LOOKUPS = ConfigKeyTypes.booleanKey("vault-unsafe-lookups", false);
        USE_VAULT_SERVER = ConfigKeyTypes.booleanKey("use-vault-server", true);
        VAULT_SERVER = ConfigKeyTypes.customKey(c -> {
            if (USE_VAULT_SERVER.get((ConfigurationAdapter)c).booleanValue()) {
                return c.getString("vault-server", "global").toLowerCase();
            }
            return SERVER.get((ConfigurationAdapter)c);
        });
        VAULT_INCLUDING_GLOBAL = ConfigKeyTypes.booleanKey("vault-include-global", true);
        VAULT_IGNORE_WORLD = ConfigKeyTypes.booleanKey("vault-ignore-world", false);
        VAULT_DEBUG = ConfigKeyTypes.booleanKey("vault-debug", false);
        WORLD_REWRITES = ConfigKeyTypes.customKey(c -> (Map)c.getStringMap("world-rewrite", (Map<String, String>)ImmutableMap.of()).entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((String)e.getKey()).toLowerCase(), e -> ((String)e.getValue()).toLowerCase())));
        GROUP_NAME_REWRITES = ConfigKeyTypes.mapKey("group-name-rewrite");
        DEFAULT_ASSIGNMENTS = ConfigKeyTypes.customKey(c -> (List)c.getKeys("default-assignments", (List<String>)ImmutableList.of()).stream().map(name -> {
            String hasTrue = c.getString("default-assignments." + name + ".if.has-true", null);
            String hasFalse = c.getString("default-assignments." + name + ".if.has-false", null);
            String lacks = c.getString("default-assignments." + name + ".if.lacks", null);
            ImmutableList give = ImmutableList.copyOf(c.getStringList("default-assignments." + name + ".give", (List<String>)ImmutableList.of()));
            ImmutableList take = ImmutableList.copyOf(c.getStringList("default-assignments." + name + ".take", (List<String>)ImmutableList.of()));
            String pg = c.getString("default-assignments." + name + ".set-primary-group", null);
            return new AssignmentRule(hasTrue, hasFalse, lacks, (List<String>)give, (List<String>)take, pg);
        }).collect(ImmutableCollectors.toList()));
        DATABASE_VALUES = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> {
            int maxPoolSize = c.getInteger("data.pool-settings.maximum-pool-size", c.getInteger("data.pool-size", 10));
            int minIdle = c.getInteger("data.pool-settings.minimum-idle", maxPoolSize);
            int maxLifetime = c.getInteger("data.pool-settings.maximum-lifetime", 1800000);
            int connectionTimeout = c.getInteger("data.pool-settings.connection-timeout", 5000);
            ImmutableMap props = ImmutableMap.copyOf(c.getStringMap("data.pool-settings.properties", (Map<String, String>)ImmutableMap.of()));
            return new StorageCredentials(c.getString("data.address", null), c.getString("data.database", null), c.getString("data.username", null), c.getString("data.password", null), maxPoolSize, minIdle, maxLifetime, connectionTimeout, (Map<String, String>)props);
        }));
        SQL_TABLE_PREFIX = ConfigKeyTypes.enduringKey(ConfigKeyTypes.stringKey("data.table_prefix", "luckperms_"));
        MONGODB_COLLECTION_PREFIX = ConfigKeyTypes.enduringKey(ConfigKeyTypes.stringKey("data.mongodb_collection_prefix", ""));
        MONGODB_CONNECTION_URI = ConfigKeyTypes.enduringKey(ConfigKeyTypes.stringKey("data.mongodb_connection_URI", ""));
        STORAGE_METHOD = ConfigKeyTypes.enduringKey(ConfigKeyTypes.lowercaseStringKey("storage-method", "h2"));
        WATCH_FILES = ConfigKeyTypes.booleanKey("watch-files", true);
        SPLIT_STORAGE = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("split-storage.enabled", false));
        SPLIT_STORAGE_OPTIONS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.customKey(c -> {
            EnumMap<SplitStorageType, String> map = new EnumMap<SplitStorageType, String>(SplitStorageType.class);
            map.put(SplitStorageType.USER, c.getString("split-storage.methods.user", "h2").toLowerCase());
            map.put(SplitStorageType.GROUP, c.getString("split-storage.methods.group", "h2").toLowerCase());
            map.put(SplitStorageType.TRACK, c.getString("split-storage.methods.track", "h2").toLowerCase());
            map.put(SplitStorageType.UUID, c.getString("split-storage.methods.uuid", "h2").toLowerCase());
            map.put(SplitStorageType.LOG, c.getString("split-storage.methods.log", "h2").toLowerCase());
            return ImmutableMap.copyOf(map);
        }));
        MESSAGING_SERVICE = ConfigKeyTypes.enduringKey(ConfigKeyTypes.lowercaseStringKey("messaging-service", "none"));
        AUTO_PUSH_UPDATES = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("auto-push-updates", true));
        PUSH_LOG_ENTRIES = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("push-log-entries", true));
        BROADCAST_RECEIVED_LOG_ENTRIES = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("broadcast-received-log-entries", false));
        REDIS_ENABLED = ConfigKeyTypes.enduringKey(ConfigKeyTypes.booleanKey("redis.enabled", false));
        REDIS_ADDRESS = ConfigKeyTypes.enduringKey(ConfigKeyTypes.stringKey("redis.address", null));
        REDIS_PASSWORD = ConfigKeyTypes.enduringKey(ConfigKeyTypes.stringKey("redis.password", ""));
        WEB_EDITOR_URL_PATTERN = ConfigKeyTypes.stringKey("web-editor-url", "https://luckperms.github.io/editor/");
        VERBOSE_VIEWER_URL_PATTERN = ConfigKeyTypes.stringKey("verbose-viewer-url", "https://luckperms.github.io/verbose/");
        TREE_VIEWER_URL_PATTERN = ConfigKeyTypes.stringKey("tree-viewer-url", "https://luckperms.github.io/treeview/");
        ORDINAL_COUNTER = new AtomicInteger(0);
        LinkedHashMap<String, ConfigKeyTypes.BaseConfigKey> keys = new LinkedHashMap<String, ConfigKeyTypes.BaseConfigKey>();
        for (Field f : values = ConfigKeys.class.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !ConfigKey.class.equals(f.getType())) continue;
            try {
                ConfigKeyTypes.BaseConfigKey key = (ConfigKeyTypes.BaseConfigKey)f.get(null);
                key.ordinal = ORDINAL_COUNTER.getAndIncrement();
                keys.put(f.getName(), key);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Exception processing field: " + f, e);
            }
        }
        KEYS = ImmutableMap.copyOf(keys);
    }
}

