/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.contexts;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import me.lucko.luckperms.lib.configurate.SimpleConfigurationNode;

public final class ContextSetConfigurateSerializer {
    public static ConfigurationNode serializeContextSet(ContextSet contextSet) {
        SimpleConfigurationNode data = SimpleConfigurationNode.root();
        Map map = contextSet.toMultimap().asMap();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList values = new ArrayList((Collection)entry.getValue());
            int size = values.size();
            if (size == 1) {
                data.getNode(new Object[]{entry.getKey()}).setValue(values.get(0));
                continue;
            }
            if (size <= 1) continue;
            data.getNode(new Object[]{entry.getKey()}).setValue(values);
        }
        return data;
    }

    public static ContextSet deserializeContextSet(ConfigurationNode data) {
        Preconditions.checkArgument((boolean)data.hasMapChildren());
        Map dataMap = data.getChildrenMap();
        if (dataMap.isEmpty()) {
            return ContextSet.empty();
        }
        MutableContextSet map = MutableContextSet.create();
        for (Map.Entry e : dataMap.entrySet()) {
            String k = e.getKey().toString();
            ConfigurationNode v = (ConfigurationNode)e.getValue();
            if (v.hasListChildren()) {
                List values = v.getChildrenList();
                for (ConfigurationNode value : values) {
                    map.add(k, value.getString());
                }
                continue;
            }
            map.add(k, v.getString());
        }
        return map;
    }

    private ContextSetConfigurateSerializer() {
    }
}

