/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.managers;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import me.lucko.luckperms.common.managers.Manager;
import me.lucko.luckperms.common.model.Identifiable;
import me.lucko.luckperms.lib.caffeine.cache.CacheLoader;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractManager<I, C extends Identifiable<I>, T extends C>
implements Manager<I, C, T> {
    private final LoadingCache<I, T> objects = Caffeine.newBuilder().build(new CacheLoader<I, T>(){

        public T load(@NonNull I i) {
            return (Identifiable)AbstractManager.this.apply(i);
        }

        public T reload(@NonNull I i, @NonNull T t) {
            return t;
        }
    });

    @Override
    public Map<I, T> getAll() {
        return ImmutableMap.copyOf((Map)this.objects.asMap());
    }

    @Override
    public T getOrMake(I id) {
        return (T)((Identifiable)this.objects.get(this.sanitizeIdentifier(id)));
    }

    @Override
    public T getIfLoaded(I id) {
        return (T)((Identifiable)this.objects.getIfPresent(this.sanitizeIdentifier(id)));
    }

    @Override
    public boolean isLoaded(I id) {
        return this.objects.asMap().containsKey(this.sanitizeIdentifier(id));
    }

    @Override
    public void unload(I id) {
        if (id != null) {
            this.objects.invalidate(this.sanitizeIdentifier(id));
        }
    }

    @Override
    public void unload(C object) {
        if (object != null) {
            this.unload((C)object.getId());
        }
    }

    @Override
    public void unloadAll() {
        this.objects.invalidateAll();
    }

    protected I sanitizeIdentifier(I i) {
        return i;
    }
}

