/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.sender;

import java.util.UUID;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.common.command.CommandManager;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.contexts.ContextManager;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.lib.text.Component;

public interface Sender {
    public LuckPermsPlugin getPlugin();

    public String getName();

    default public String getNameWithLocation() {
        String name = this.getName();
        ContextManager<?> contextManager = this.getPlugin().getContextManager();
        if (contextManager == null) {
            return name;
        }
        String location = contextManager.getStaticContextString().orElse(null);
        if (location == null) {
            return name;
        }
        if (this.isConsole()) {
            return name.toLowerCase() + "@" + location;
        }
        return name + "@" + location;
    }

    public UUID getUuid();

    public void sendMessage(String var1);

    public void sendMessage(Component var1);

    public Tristate getPermissionValue(String var1);

    public boolean hasPermission(String var1);

    default public boolean hasPermission(CommandPermission permission) {
        return this.hasPermission(permission.getPermission());
    }

    default public boolean isConsole() {
        return CommandManager.CONSOLE_UUID.equals(this.getUuid()) || CommandManager.IMPORT_UUID.equals(this.getUuid());
    }

    default public boolean isImport() {
        return CommandManager.IMPORT_UUID.equals(this.getUuid());
    }

    default public boolean isValid() {
        return true;
    }
}

