/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.file;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.ChatMetaType;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.PlayerSaveResult;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.contexts.ContextSetConfigurateSerializer;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.model.UserIdentifier;
import me.lucko.luckperms.common.node.factory.NodeFactory;
import me.lucko.luckperms.common.node.model.NodeDataContainer;
import me.lucko.luckperms.common.node.utils.MetaType;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.StorageImplementation;
import me.lucko.luckperms.common.storage.implementation.file.FileActionLogger;
import me.lucko.luckperms.common.storage.implementation.file.FileUuidCache;
import me.lucko.luckperms.common.storage.implementation.file.SeparatedConfigurateStorage;
import me.lucko.luckperms.common.storage.implementation.file.StorageLocation;
import me.lucko.luckperms.common.storage.implementation.file.loader.ConfigurateLoader;
import me.lucko.luckperms.common.storage.implementation.file.loader.JsonLoader;
import me.lucko.luckperms.common.storage.implementation.file.loader.YamlLoader;
import me.lucko.luckperms.common.utils.ImmutableCollectors;
import me.lucko.luckperms.common.utils.MoreFiles;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import me.lucko.luckperms.lib.configurate.SimpleConfigurationNode;
import me.lucko.luckperms.lib.configurate.Types;

public abstract class AbstractConfigurateStorage
implements StorageImplementation {
    protected final LuckPermsPlugin plugin;
    private final String implementationName;
    protected final ConfigurateLoader loader;
    private final String dataDirectoryName;
    protected Path dataDirectory;
    private final FileUuidCache uuidCache = new FileUuidCache();
    private final FileActionLogger actionLogger;
    private Path uuidDataFile;

    protected AbstractConfigurateStorage(LuckPermsPlugin plugin, String implementationName, ConfigurateLoader loader, String dataDirectoryName) {
        this.plugin = plugin;
        this.implementationName = implementationName;
        this.loader = loader;
        this.dataDirectoryName = dataDirectoryName;
        this.actionLogger = new FileActionLogger(plugin);
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return this.implementationName;
    }

    protected abstract ConfigurationNode readFile(StorageLocation var1, String var2) throws IOException;

    protected abstract void saveFile(StorageLocation var1, String var2, ConfigurationNode var3) throws IOException;

    protected RuntimeException reportException(String file, Exception ex) throws RuntimeException {
        this.plugin.getLogger().warn("Exception thrown whilst performing i/o: " + file);
        ex.printStackTrace();
        throw Throwables.propagate((Throwable)ex);
    }

    @Override
    public void init() throws IOException {
        this.dataDirectory = this.plugin.getBootstrap().getDataDirectory().resolve(this.dataDirectoryName);
        MoreFiles.createDirectoriesIfNotExists(this.dataDirectory);
        this.uuidDataFile = MoreFiles.createFileIfNotExists(this.dataDirectory.resolve("uuidcache.txt"));
        this.uuidCache.load(this.uuidDataFile);
        this.actionLogger.init(this.dataDirectory.resolve("actions.json"));
    }

    @Override
    public void shutdown() {
        this.uuidCache.save(this.uuidDataFile);
        this.actionLogger.flush();
    }

    @Override
    public void logAction(LogEntry entry) {
        this.actionLogger.logAction(entry);
    }

    @Override
    public Log getLog() throws IOException {
        return this.actionLogger.getLog();
    }

    protected ConfigurationNode processBulkUpdate(BulkUpdate bulkUpdate, ConfigurationNode node) {
        Set<NodeDataContainer> nodes = AbstractConfigurateStorage.readNodes(node);
        Set<NodeDataContainer> results = nodes.stream().map(bulkUpdate::apply).filter(Objects::nonNull).collect(Collectors.toSet());
        if (nodes.equals(results)) {
            return null;
        }
        this.writeNodes(node, results);
        return node;
    }

    @Override
    public User loadUser(UUID uuid, String username) {
        User user = (User)this.plugin.getUserManager().getOrMake(UserIdentifier.of(uuid, username));
        user.getIoLock().lock();
        try {
            ConfigurationNode object = this.readFile(StorageLocation.USER, uuid.toString());
            if (object != null) {
                String name = object.getNode(new Object[]{"name"}).getString();
                user.getPrimaryGroup().setStoredValue(object.getNode(new Object[]{this.loader instanceof JsonLoader ? "primaryGroup" : "primary-group"}).getString());
                Set nodes = AbstractConfigurateStorage.readNodes(object).stream().map(NodeDataContainer::toNode).collect(Collectors.toSet());
                user.setNodes(NodeMapType.ENDURING, nodes);
                user.setName(name, true);
                boolean save = this.plugin.getUserManager().giveDefaultIfNeeded(user, false);
                if (user.getName().isPresent() && (name == null || !user.getName().get().equalsIgnoreCase(name))) {
                    save = true;
                }
                if (save | user.auditTemporaryPermissions()) {
                    this.saveUser(user);
                }
            } else if (this.plugin.getUserManager().shouldSave(user)) {
                user.clearNodes();
                user.getPrimaryGroup().setStoredValue(null);
                this.plugin.getUserManager().giveDefaultIfNeeded(user, false);
            }
        }
        catch (Exception e) {
            throw this.reportException(uuid.toString(), e);
        }
        finally {
            user.invalidateCachedData();
            user.getIoLock().unlock();
        }
        return user;
    }

    @Override
    public void saveUser(User user) {
        user.getIoLock().lock();
        try {
            if (!this.plugin.getUserManager().shouldSave(user)) {
                this.saveFile(StorageLocation.USER, user.getUuid().toString(), null);
            } else {
                SimpleConfigurationNode data = SimpleConfigurationNode.root();
                if (this instanceof SeparatedConfigurateStorage) {
                    data.getNode(new Object[]{"uuid"}).setValue((Object)user.getUuid().toString());
                }
                data.getNode(new Object[]{"name"}).setValue((Object)user.getName().orElse("null"));
                data.getNode(new Object[]{this.loader instanceof JsonLoader ? "primaryGroup" : "primary-group"}).setValue((Object)user.getPrimaryGroup().getStoredValue().orElse("default"));
                Set nodes = user.enduringData().immutable().values().stream().map(NodeDataContainer::fromNode).collect(Collectors.toCollection(LinkedHashSet::new));
                this.writeNodes((ConfigurationNode)data, nodes);
                this.saveFile(StorageLocation.USER, user.getUuid().toString(), (ConfigurationNode)data);
            }
        }
        catch (Exception e) {
            throw this.reportException(user.getUuid().toString(), e);
        }
        finally {
            user.getIoLock().unlock();
        }
    }

    @Override
    public Group createAndLoadGroup(String name) {
        Group group = (Group)this.plugin.getGroupManager().getOrMake(name);
        group.getIoLock().lock();
        try {
            ConfigurationNode object = this.readFile(StorageLocation.GROUP, name);
            if (object != null) {
                Set nodes = AbstractConfigurateStorage.readNodes(object).stream().map(NodeDataContainer::toNode).collect(Collectors.toSet());
                group.setNodes(NodeMapType.ENDURING, nodes);
            } else {
                SimpleConfigurationNode data = SimpleConfigurationNode.root();
                if (this instanceof SeparatedConfigurateStorage) {
                    data.getNode(new Object[]{"name"}).setValue((Object)group.getName());
                }
                Set nodes = group.enduringData().immutable().values().stream().map(NodeDataContainer::fromNode).collect(Collectors.toCollection(LinkedHashSet::new));
                this.writeNodes((ConfigurationNode)data, nodes);
                this.saveFile(StorageLocation.GROUP, name, (ConfigurationNode)data);
            }
        }
        catch (Exception e) {
            throw this.reportException(name, e);
        }
        finally {
            group.invalidateCachedData();
            group.getIoLock().unlock();
        }
        return group;
    }

    @Override
    public Optional<Group> loadGroup(String name) {
        Group group = (Group)this.plugin.getGroupManager().getIfLoaded(name);
        if (group != null) {
            group.getIoLock().lock();
        }
        try {
            ConfigurationNode object = this.readFile(StorageLocation.GROUP, name);
            if (object == null) {
                Optional<Group> optional = Optional.empty();
                return optional;
            }
            if (group == null) {
                group = (Group)this.plugin.getGroupManager().getOrMake(name);
                group.getIoLock().lock();
            }
            Set<NodeDataContainer> data = AbstractConfigurateStorage.readNodes(object);
            Set nodes = data.stream().map(NodeDataContainer::toNode).collect(Collectors.toSet());
            group.setNodes(NodeMapType.ENDURING, nodes);
        }
        catch (Exception e) {
            throw this.reportException(name, e);
        }
        finally {
            if (group != null) {
                group.invalidateCachedData();
                group.getIoLock().unlock();
            }
        }
        return Optional.of(group);
    }

    @Override
    public void saveGroup(Group group) {
        group.getIoLock().lock();
        try {
            SimpleConfigurationNode data = SimpleConfigurationNode.root();
            if (this instanceof SeparatedConfigurateStorage) {
                data.getNode(new Object[]{"name"}).setValue((Object)group.getName());
            }
            Set nodes = group.enduringData().immutable().values().stream().map(NodeDataContainer::fromNode).collect(Collectors.toCollection(LinkedHashSet::new));
            this.writeNodes((ConfigurationNode)data, nodes);
            this.saveFile(StorageLocation.GROUP, group.getName(), (ConfigurationNode)data);
        }
        catch (Exception e) {
            throw this.reportException(group.getName(), e);
        }
        finally {
            group.getIoLock().unlock();
        }
    }

    @Override
    public void deleteGroup(Group group) {
        group.getIoLock().lock();
        try {
            this.saveFile(StorageLocation.GROUP, group.getName(), null);
        }
        catch (Exception e) {
            throw this.reportException(group.getName(), e);
        }
        finally {
            group.getIoLock().unlock();
        }
        this.plugin.getGroupManager().unload(group);
    }

    @Override
    public Track createAndLoadTrack(String name) {
        Track track = (Track)this.plugin.getTrackManager().getOrMake(name);
        track.getIoLock().lock();
        try {
            ConfigurationNode object = this.readFile(StorageLocation.TRACK, name);
            if (object != null) {
                List groups = (List)object.getNode(new Object[]{"groups"}).getChildrenList().stream().map(ConfigurationNode::getString).collect(ImmutableCollectors.toList());
                track.setGroups(groups);
            } else {
                SimpleConfigurationNode data = SimpleConfigurationNode.root();
                if (this instanceof SeparatedConfigurateStorage) {
                    data.getNode(new Object[]{"name"}).setValue((Object)name);
                }
                data.getNode(new Object[]{"groups"}).setValue(track.getGroups());
                this.saveFile(StorageLocation.TRACK, name, (ConfigurationNode)data);
            }
        }
        catch (Exception e) {
            throw this.reportException(name, e);
        }
        finally {
            track.getIoLock().unlock();
        }
        return track;
    }

    @Override
    public Optional<Track> loadTrack(String name) {
        Track track = (Track)this.plugin.getTrackManager().getIfLoaded(name);
        if (track != null) {
            track.getIoLock().lock();
        }
        try {
            ConfigurationNode object = this.readFile(StorageLocation.TRACK, name);
            if (object == null) {
                Optional<Track> optional = Optional.empty();
                return optional;
            }
            if (track == null) {
                track = (Track)this.plugin.getTrackManager().getOrMake(name);
                track.getIoLock().lock();
            }
            List groups = (List)object.getNode(new Object[]{"groups"}).getChildrenList().stream().map(ConfigurationNode::getString).collect(ImmutableCollectors.toList());
            track.setGroups(groups);
        }
        catch (Exception e) {
            throw this.reportException(name, e);
        }
        finally {
            if (track != null) {
                track.getIoLock().unlock();
            }
        }
        return Optional.of(track);
    }

    @Override
    public void saveTrack(Track track) {
        track.getIoLock().lock();
        try {
            SimpleConfigurationNode data = SimpleConfigurationNode.root();
            if (this instanceof SeparatedConfigurateStorage) {
                data.getNode(new Object[]{"name"}).setValue((Object)track.getName());
            }
            data.getNode(new Object[]{"groups"}).setValue(track.getGroups());
            this.saveFile(StorageLocation.TRACK, track.getName(), (ConfigurationNode)data);
        }
        catch (Exception e) {
            throw this.reportException(track.getName(), e);
        }
        finally {
            track.getIoLock().unlock();
        }
    }

    @Override
    public void deleteTrack(Track track) {
        track.getIoLock().lock();
        try {
            this.saveFile(StorageLocation.TRACK, track.getName(), null);
        }
        catch (Exception e) {
            throw this.reportException(track.getName(), e);
        }
        finally {
            track.getIoLock().unlock();
        }
        this.plugin.getTrackManager().unload(track);
    }

    @Override
    public PlayerSaveResult savePlayerData(UUID uuid, String username) {
        return this.uuidCache.addMapping(uuid, username);
    }

    @Override
    public UUID getPlayerUuid(String username) {
        return this.uuidCache.lookupUuid(username);
    }

    @Override
    public String getPlayerName(UUID uuid) {
        return this.uuidCache.lookupUsername(uuid);
    }

    private static NodeDataContainer readAttributes(ConfigurationNode attributes, Function<ConfigurationNode, String> permissionFunction) {
        boolean value = attributes.getNode(new Object[]{"value"}).getBoolean(true);
        String server = attributes.getNode(new Object[]{"server"}).getString("global");
        String world = attributes.getNode(new Object[]{"world"}).getString("global");
        long expiry = attributes.getNode(new Object[]{"expiry"}).getLong(0L);
        ImmutableContextSet context = ImmutableContextSet.empty();
        ConfigurationNode contextMap = attributes.getNode(new Object[]{"context"});
        if (!contextMap.isVirtual() && contextMap.hasMapChildren()) {
            context = ContextSetConfigurateSerializer.deserializeContextSet(contextMap).makeImmutable();
        }
        return NodeDataContainer.of(permissionFunction.apply(attributes), value, server, world, expiry, context);
    }

    private static Collection<NodeDataContainer> readAttributes(ConfigurationNode attributes, String permission) {
        boolean value = attributes.getNode(new Object[]{"value"}).getBoolean(true);
        String server = attributes.getNode(new Object[]{"server"}).getString("global");
        String world = attributes.getNode(new Object[]{"world"}).getString("global");
        long expiry = attributes.getNode(new Object[]{"expiry"}).getLong(0L);
        ImmutableContextSet context = ImmutableContextSet.empty();
        ConfigurationNode contextMap = attributes.getNode(new Object[]{"context"});
        if (!contextMap.isVirtual() && contextMap.hasMapChildren()) {
            context = ContextSetConfigurateSerializer.deserializeContextSet(contextMap).makeImmutable();
        }
        ConfigurationNode batchAttribute = attributes.getNode(new Object[]{"permissions"});
        if (permission.startsWith("luckperms.batch") && !batchAttribute.isVirtual() && batchAttribute.hasListChildren()) {
            ArrayList<NodeDataContainer> nodes = new ArrayList<NodeDataContainer>();
            for (ConfigurationNode element : batchAttribute.getChildrenList()) {
                nodes.add(NodeDataContainer.of(element.getString(), value, server, world, expiry, context));
            }
            return nodes;
        }
        return Collections.singleton(NodeDataContainer.of(permission, value, server, world, expiry, context));
    }

    private static Map.Entry<String, ConfigurationNode> parseEntry(ConfigurationNode appended, String keyFieldName) {
        String permission;
        Map.Entry entry;
        if (!appended.hasMapChildren()) {
            return null;
        }
        Map children = appended.getChildrenMap();
        if (children.isEmpty()) {
            return null;
        }
        if (children.size() == 1 && (entry = (Map.Entry)Iterables.getFirst(children.entrySet(), null)) != null) {
            String permission2 = entry.getKey().toString();
            ConfigurationNode attributes = (ConfigurationNode)entry.getValue();
            if (!permission2.equals(keyFieldName)) {
                return Maps.immutableEntry((Object)permission2, (Object)attributes);
            }
        }
        if ((permission = ((ConfigurationNode)children.get(keyFieldName)).getString(null)) == null) {
            return null;
        }
        return Maps.immutableEntry((Object)permission, (Object)appended);
    }

    protected static Set<NodeDataContainer> readNodes(ConfigurationNode data) {
        Map.Entry<String, ConfigurationNode> entry;
        ConfigurationNode appended;
        Iterator iterator;
        Object children;
        HashSet<NodeDataContainer> nodes = new HashSet<NodeDataContainer>();
        if (data.getNode(new Object[]{"permissions"}).hasListChildren()) {
            children = data.getNode(new Object[]{"permissions"}).getChildrenList();
            iterator = children.iterator();
            while (iterator.hasNext()) {
                appended = (ConfigurationNode)iterator.next();
                String plainValue = (String)appended.getValue(Types::strictAsString);
                if (plainValue != null) {
                    nodes.add(NodeDataContainer.of(plainValue));
                    continue;
                }
                entry = AbstractConfigurateStorage.parseEntry(appended, "permission");
                if (entry == null) continue;
                nodes.addAll(AbstractConfigurateStorage.readAttributes(entry.getValue(), entry.getKey()));
            }
        }
        if (data.getNode(new Object[]{"parents"}).hasListChildren()) {
            children = data.getNode(new Object[]{"parents"}).getChildrenList();
            iterator = children.iterator();
            while (iterator.hasNext()) {
                appended = (ConfigurationNode)iterator.next();
                String stringValue = (String)appended.getValue(Types::strictAsString);
                if (stringValue != null) {
                    nodes.add(NodeDataContainer.of(NodeFactory.groupNode(stringValue)));
                    continue;
                }
                entry = AbstractConfigurateStorage.parseEntry(appended, "group");
                if (entry == null) continue;
                nodes.add(AbstractConfigurateStorage.readAttributes(entry.getValue(), (ConfigurationNode c) -> NodeFactory.groupNode((String)entry.getKey())));
            }
        }
        for (ChatMetaType chatMetaType : ChatMetaType.values()) {
            String keyName = chatMetaType.toString() + "es";
            if (!data.getNode(new Object[]{keyName}).hasListChildren()) continue;
            List children2 = data.getNode(new Object[]{keyName}).getChildrenList();
            for (ConfigurationNode appended2 : children2) {
                Map.Entry<String, ConfigurationNode> entry2 = AbstractConfigurateStorage.parseEntry(appended2, chatMetaType.toString());
                if (entry2 == null) continue;
                nodes.add(AbstractConfigurateStorage.readAttributes(entry2.getValue(), (ConfigurationNode c) -> NodeFactory.chatMetaNode(chatMetaType, c.getNode(new Object[]{"priority"}).getInt(0), (String)entry2.getKey())));
            }
        }
        if (data.getNode(new Object[]{"meta"}).hasListChildren()) {
            children = data.getNode(new Object[]{"meta"}).getChildrenList();
            Iterator iterator2 = children.iterator();
            while (iterator2.hasNext()) {
                ConfigurationNode appended3 = (ConfigurationNode)iterator2.next();
                Map.Entry<String, ConfigurationNode> entry3 = AbstractConfigurateStorage.parseEntry(appended3, "key");
                if (entry3 == null) continue;
                nodes.add(AbstractConfigurateStorage.readAttributes(entry3.getValue(), (ConfigurationNode c) -> NodeFactory.metaNode((String)entry3.getKey(), c.getNode(new Object[]{"value"}).getString("null"))));
            }
        }
        return nodes;
    }

    private static void writeAttributesTo(ConfigurationNode attributes, NodeDataContainer node, boolean writeValue) {
        if (writeValue) {
            attributes.getNode(new Object[]{"value"}).setValue((Object)node.getValue());
        }
        if (!node.getServer().equals("global")) {
            attributes.getNode(new Object[]{"server"}).setValue((Object)node.getServer());
        }
        if (!node.getWorld().equals("global")) {
            attributes.getNode(new Object[]{"world"}).setValue((Object)node.getWorld());
        }
        if (node.getExpiry() != 0L) {
            attributes.getNode(new Object[]{"expiry"}).setValue((Object)node.getExpiry());
        }
        if (!node.getContexts().isEmpty()) {
            attributes.getNode(new Object[]{"context"}).setValue((Object)ContextSetConfigurateSerializer.serializeContextSet(node.getContexts()));
        }
    }

    private static boolean isPlain(NodeDataContainer node) {
        return node.getValue() && node.getServer().equalsIgnoreCase("global") && node.getWorld().equalsIgnoreCase("global") && node.getExpiry() == 0L && node.getContexts().isEmpty();
    }

    private void appendNode(ConfigurationNode base, String key, ConfigurationNode attributes, String keyFieldName) {
        if (this.loader instanceof YamlLoader) {
            ConfigurationNode appended = base.getAppendedNode();
            appended.getNode(new Object[]{key}).setValue((Object)attributes);
        } else {
            ConfigurationNode appended = base.getAppendedNode();
            appended.getNode(new Object[]{keyFieldName}).setValue((Object)key);
            appended.mergeValuesFrom(attributes);
        }
    }

    private void writeNodes(ConfigurationNode to, Set<NodeDataContainer> nodes) {
        SimpleConfigurationNode permissionsSection = SimpleConfigurationNode.root();
        SimpleConfigurationNode parentsSection = SimpleConfigurationNode.root();
        SimpleConfigurationNode prefixesSection = SimpleConfigurationNode.root();
        SimpleConfigurationNode suffixesSection = SimpleConfigurationNode.root();
        SimpleConfigurationNode metaSection = SimpleConfigurationNode.root();
        for (NodeDataContainer node : nodes) {
            SimpleConfigurationNode attributes;
            SimpleConfigurationNode attributes2;
            ChatMetaType chatMetaType;
            Node n = node.toNode();
            if (this.loader instanceof YamlLoader && AbstractConfigurateStorage.isPlain(node)) {
                if (n.isGroupNode()) {
                    parentsSection.getAppendedNode().setValue((Object)n.getGroupName());
                    continue;
                }
                if (!MetaType.ANY.matches(n)) {
                    permissionsSection.getAppendedNode().setValue((Object)node.getPermission());
                    continue;
                }
            }
            if ((chatMetaType = (ChatMetaType)ChatMetaType.ofNode(n).orElse(null)) != null && n.getValue()) {
                Map.Entry<Integer, String> entry = chatMetaType.getEntry(n);
                attributes2 = SimpleConfigurationNode.root();
                attributes2.getNode(new Object[]{"priority"}).setValue((Object)entry.getKey());
                AbstractConfigurateStorage.writeAttributesTo((ConfigurationNode)attributes2, node, false);
                switch (chatMetaType) {
                    case PREFIX: {
                        this.appendNode((ConfigurationNode)prefixesSection, entry.getValue(), (ConfigurationNode)attributes2, "prefix");
                        break;
                    }
                    case SUFFIX: {
                        this.appendNode((ConfigurationNode)suffixesSection, entry.getValue(), (ConfigurationNode)attributes2, "suffix");
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                continue;
            }
            if (n.isMeta() && n.getValue()) {
                Map.Entry<String, String> meta = n.getMeta();
                attributes2 = SimpleConfigurationNode.root();
                attributes2.getNode(new Object[]{"value"}).setValue((Object)meta.getValue());
                AbstractConfigurateStorage.writeAttributesTo((ConfigurationNode)attributes2, node, false);
                this.appendNode((ConfigurationNode)metaSection, meta.getKey(), (ConfigurationNode)attributes2, "key");
                continue;
            }
            if (n.isGroupNode() && n.getValue()) {
                attributes = SimpleConfigurationNode.root();
                AbstractConfigurateStorage.writeAttributesTo((ConfigurationNode)attributes, node, false);
                this.appendNode((ConfigurationNode)parentsSection, n.getGroupName(), (ConfigurationNode)attributes, "group");
                continue;
            }
            attributes = SimpleConfigurationNode.root();
            AbstractConfigurateStorage.writeAttributesTo((ConfigurationNode)attributes, node, true);
            this.appendNode((ConfigurationNode)permissionsSection, n.getPermission(), (ConfigurationNode)attributes, "permission");
        }
        if (permissionsSection.hasListChildren()) {
            to.getNode(new Object[]{"permissions"}).setValue((Object)permissionsSection);
        }
        if (parentsSection.hasListChildren()) {
            to.getNode(new Object[]{"parents"}).setValue((Object)parentsSection);
        }
        if (prefixesSection.hasListChildren()) {
            to.getNode(new Object[]{"prefixes"}).setValue((Object)prefixesSection);
        }
        if (suffixesSection.hasListChildren()) {
            to.getNode(new Object[]{"suffixes"}).setValue((Object)suffixesSection);
        }
        if (metaSection.hasListChildren()) {
            to.getNode(new Object[]{"meta"}).setValue((Object)metaSection);
        }
    }
}

