/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.split;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.lucko.luckperms.api.HeldPermission;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.PlayerSaveResult;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.bulkupdate.comparisons.Constraint;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.StorageType;
import me.lucko.luckperms.common.storage.implementation.StorageImplementation;
import me.lucko.luckperms.common.storage.implementation.split.SplitStorageType;

public class SplitStorage
implements StorageImplementation {
    private final LuckPermsPlugin plugin;
    private final Map<StorageType, StorageImplementation> backing;
    private final Map<SplitStorageType, StorageType> types;

    public SplitStorage(LuckPermsPlugin plugin, Map<StorageType, StorageImplementation> backing, Map<SplitStorageType, StorageType> types) {
        this.plugin = plugin;
        this.backing = ImmutableMap.copyOf(backing);
        this.types = ImmutableMap.copyOf(types);
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return "Split Storage";
    }

    @Override
    public void init() {
        boolean failed = false;
        for (StorageImplementation ds : this.backing.values()) {
            try {
                ds.init();
            }
            catch (Exception ex) {
                failed = true;
                ex.printStackTrace();
            }
        }
        if (failed) {
            throw new RuntimeException("One of the backings failed to init");
        }
    }

    @Override
    public void shutdown() {
        for (StorageImplementation ds : this.backing.values()) {
            try {
                ds.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Map<String, String> getMeta() {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        ret.put("Types", this.types.toString());
        for (StorageImplementation backing : this.backing.values()) {
            ret.putAll(backing.getMeta());
        }
        return ret;
    }

    @Override
    public void logAction(LogEntry entry) throws Exception {
        this.backing.get((Object)this.types.get((Object)SplitStorageType.LOG)).logAction(entry);
    }

    @Override
    public Log getLog() throws Exception {
        return this.backing.get((Object)this.types.get((Object)SplitStorageType.LOG)).getLog();
    }

    @Override
    public void applyBulkUpdate(BulkUpdate bulkUpdate) throws Exception {
        StorageType userType = this.types.get((Object)SplitStorageType.USER);
        StorageType groupType = this.types.get((Object)SplitStorageType.GROUP);
        this.backing.get((Object)userType).applyBulkUpdate(bulkUpdate);
        if (userType != groupType) {
            this.backing.get((Object)groupType).applyBulkUpdate(bulkUpdate);
        }
    }

    @Override
    public User loadUser(UUID uuid, String username) throws Exception {
        return this.backing.get((Object)this.types.get((Object)SplitStorageType.USER)).loadUser(uuid, username);
    }

    @Override
    public void saveUser(User user) throws Exception {
        this.backing.get((Object)this.types.get((Object)SplitStorageType.USER)).saveUser(user);
    }

    @Override
    public Set<UUID> getUniqueUsers() throws Exception {
        return this.backing.get((Object)this.types.get((Object)SplitStorageType.USER)).getUniqueUsers();
    }

    @Override
    public List<HeldPermission<UUID>> getUsersWithPermission(Constraint constraint) throws Exception {
        return this.backing.get((Object)this.types.get((Object)SplitStorageType.USER)).getUsersWithPermission(constraint);
    }

    @Override
    public Group createAndLoadGroup(String name) throws Exception {
        return this.backing.get((Object)this.types.get((Object)SplitStorageType.GROUP)).createAndLoadGroup(name);
    }

    @Override
    public Optional<Group> loadGroup(String name) throws Exception {
        return this.backing.get((Object)this.types.get((Object)SplitStorageType.GROUP)).loadGroup(name);
    }

    @Override
    public void loadAllGroups() throws Exception {
        this.backing.get((Object)this.types.get((Object)SplitStorageType.GROUP)).loadAllGroups();
    }

    @Override
    public void saveGroup(Group group) throws Exception {
        this.backing.get((Object)this.types.get((Object)SplitStorageType.GROUP)).saveGroup(group);
    }

    @Override
    public void deleteGroup(Group group) throws Exception {
        this.backing.get((Object)this.types.get((Object)SplitStorageType.GROUP)).deleteGroup(group);
    }

    @Override
    public List<HeldPermission<String>> getGroupsWithPermission(Constraint constraint) throws Exception {
        return this.backing.get((Object)this.types.get((Object)SplitStorageType.GROUP)).getGroupsWithPermission(constraint);
    }

    @Override
    public Track createAndLoadTrack(String name) throws Exception {
        return this.backing.get((Object)this.types.get((Object)SplitStorageType.TRACK)).createAndLoadTrack(name);
    }

    @Override
    public Optional<Track> loadTrack(String name) throws Exception {
        return this.backing.get((Object)this.types.get((Object)SplitStorageType.TRACK)).loadTrack(name);
    }

    @Override
    public void loadAllTracks() throws Exception {
        this.backing.get((Object)this.types.get((Object)SplitStorageType.TRACK)).loadAllTracks();
    }

    @Override
    public void saveTrack(Track track) throws Exception {
        this.backing.get((Object)this.types.get((Object)SplitStorageType.TRACK)).saveTrack(track);
    }

    @Override
    public void deleteTrack(Track track) throws Exception {
        this.backing.get((Object)this.types.get((Object)SplitStorageType.TRACK)).deleteTrack(track);
    }

    @Override
    public PlayerSaveResult savePlayerData(UUID uuid, String username) throws Exception {
        return this.backing.get((Object)this.types.get((Object)SplitStorageType.UUID)).savePlayerData(uuid, username);
    }

    @Override
    public UUID getPlayerUuid(String username) throws Exception {
        return this.backing.get((Object)this.types.get((Object)SplitStorageType.UUID)).getPlayerUuid(username);
    }

    @Override
    public String getPlayerName(UUID uuid) throws Exception {
        return this.backing.get((Object)this.types.get((Object)SplitStorageType.UUID)).getPlayerName(uuid);
    }
}

