/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.calculated;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.caching.type.MetaAccumulator;
import me.lucko.luckperms.common.graph.TraversalAlgorithm;
import me.lucko.luckperms.common.verbose.CheckOrigin;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.service.calculated.CalculatedSubjectData;
import me.lucko.luckperms.sponge.service.calculated.SubjectCachedData;
import me.lucko.luckperms.sponge.service.inheritance.SubjectInheritanceGraph;
import me.lucko.luckperms.sponge.service.inheritance.SubjectInheritanceGraphs;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;

public abstract class CalculatedSubject
implements LPSubject {
    private final LPSpongePlugin plugin;
    private final SubjectCachedData cachedData;

    protected CalculatedSubject(LPSpongePlugin plugin) {
        this.plugin = plugin;
        this.cachedData = new SubjectCachedData(this, plugin);
    }

    @Override
    public LPSubject getDefaults() {
        return this.plugin.getService().getDefaultSubjects().getTypeDefaults(this.getParentCollection().getIdentifier());
    }

    @Override
    public abstract CalculatedSubjectData getSubjectData();

    @Override
    public abstract CalculatedSubjectData getTransientSubjectData();

    public Map<String, Boolean> getCombinedPermissions(ContextSet filter) {
        Map<String, Boolean> merging;
        Map<String, Boolean> permissions;
        switch (this.getParentCollection().getResolutionOrder()) {
            case TRANSIENT_FIRST: {
                permissions = this.getTransientSubjectData().resolvePermissions(filter);
                merging = this.getSubjectData().resolvePermissions(filter);
                break;
            }
            case TRANSIENT_LAST: {
                permissions = this.getSubjectData().resolvePermissions(filter);
                merging = this.getTransientSubjectData().resolvePermissions(filter);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (Map.Entry<String, Boolean> entry : merging.entrySet()) {
            permissions.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return permissions;
    }

    public Map<String, Boolean> getCombinedPermissions() {
        Map<String, Boolean> merging;
        Map<String, Boolean> permissions;
        switch (this.getParentCollection().getResolutionOrder()) {
            case TRANSIENT_FIRST: {
                permissions = this.getTransientSubjectData().resolvePermissions();
                merging = this.getSubjectData().resolvePermissions();
                break;
            }
            case TRANSIENT_LAST: {
                permissions = this.getSubjectData().resolvePermissions();
                merging = this.getTransientSubjectData().resolvePermissions();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (Map.Entry<String, Boolean> entry : merging.entrySet()) {
            permissions.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return permissions;
    }

    public Map<String, Boolean> resolveAllPermissions(ImmutableContextSet filter) {
        SubjectInheritanceGraph graph = SubjectInheritanceGraphs.getGraph(filter);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Iterable<CalculatedSubject> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this);
        for (CalculatedSubject subject : traversal) {
            for (Map.Entry<String, Boolean> entry : subject.getCombinedPermissions(filter).entrySet()) {
                result.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public Map<String, Boolean> resolveAllPermissions() {
        SubjectInheritanceGraph graph = SubjectInheritanceGraphs.getGraph();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Iterable<CalculatedSubject> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this);
        for (CalculatedSubject subject : traversal) {
            for (Map.Entry<String, Boolean> entry : subject.getCombinedPermissions().entrySet()) {
                result.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public Set<LPSubjectReference> getCombinedParents(ContextSet filter) {
        Set<LPSubjectReference> merging;
        Set<LPSubjectReference> parents;
        switch (this.getParentCollection().getResolutionOrder()) {
            case TRANSIENT_FIRST: {
                parents = this.getTransientSubjectData().resolveParents(filter);
                merging = this.getSubjectData().resolveParents(filter);
                break;
            }
            case TRANSIENT_LAST: {
                parents = this.getSubjectData().resolveParents(filter);
                merging = this.getTransientSubjectData().resolveParents(filter);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        parents.addAll(merging);
        return parents;
    }

    public Set<LPSubjectReference> getCombinedParents() {
        Set<LPSubjectReference> merging;
        Set<LPSubjectReference> parents;
        switch (this.getParentCollection().getResolutionOrder()) {
            case TRANSIENT_FIRST: {
                parents = this.getTransientSubjectData().resolveParents();
                merging = this.getSubjectData().resolveParents();
                break;
            }
            case TRANSIENT_LAST: {
                parents = this.getSubjectData().resolveParents();
                merging = this.getTransientSubjectData().resolveParents();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        parents.addAll(merging);
        return parents;
    }

    public Set<LPSubjectReference> resolveAllParents(ImmutableContextSet filter) {
        SubjectInheritanceGraph graph = SubjectInheritanceGraphs.getGraph(filter);
        LinkedHashSet<LPSubjectReference> result = new LinkedHashSet<LPSubjectReference>();
        Iterable<CalculatedSubject> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this);
        for (CalculatedSubject subject : traversal) {
            result.addAll(subject.getCombinedParents(filter));
        }
        return result;
    }

    public Set<LPSubjectReference> resolveAllParents() {
        SubjectInheritanceGraph graph = SubjectInheritanceGraphs.getGraph();
        LinkedHashSet<LPSubjectReference> result = new LinkedHashSet<LPSubjectReference>();
        Iterable<CalculatedSubject> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this);
        for (CalculatedSubject subject : traversal) {
            result.addAll(subject.getCombinedParents());
        }
        return result;
    }

    public Map<String, String> getCombinedOptions(ContextSet filter) {
        Map<String, String> merging;
        Map<String, String> options;
        switch (this.getParentCollection().getResolutionOrder()) {
            case TRANSIENT_FIRST: {
                options = this.getTransientSubjectData().resolveOptions(filter);
                merging = this.getSubjectData().resolveOptions(filter);
                break;
            }
            case TRANSIENT_LAST: {
                options = this.getSubjectData().resolveOptions(filter);
                merging = this.getTransientSubjectData().resolveOptions(filter);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (Map.Entry<String, String> entry : merging.entrySet()) {
            options.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return options;
    }

    public Map<String, String> getCombinedOptions() {
        Map<String, String> merging;
        Map<String, String> options;
        switch (this.getParentCollection().getResolutionOrder()) {
            case TRANSIENT_FIRST: {
                options = this.getTransientSubjectData().resolveOptions();
                merging = this.getSubjectData().resolveOptions();
                break;
            }
            case TRANSIENT_LAST: {
                options = this.getSubjectData().resolveOptions();
                merging = this.getTransientSubjectData().resolveOptions();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (Map.Entry<String, String> entry : merging.entrySet()) {
            options.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return options;
    }

    public Map<String, String> resolveAllOptions(ImmutableContextSet filter) {
        SubjectInheritanceGraph graph = SubjectInheritanceGraphs.getGraph(filter);
        HashMap<String, String> result = new HashMap<String, String>();
        Iterable<CalculatedSubject> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this);
        for (CalculatedSubject subject : traversal) {
            for (Map.Entry<String, String> entry : subject.getCombinedOptions(filter).entrySet()) {
                result.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public Map<String, String> resolveAllOptions() {
        SubjectInheritanceGraph graph = SubjectInheritanceGraphs.getGraph();
        HashMap<String, String> result = new HashMap<String, String>();
        Iterable<CalculatedSubject> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this);
        for (CalculatedSubject subject : traversal) {
            for (Map.Entry<String, String> entry : subject.getCombinedOptions().entrySet()) {
                result.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public void resolveAllOptions(MetaAccumulator accumulator, ImmutableContextSet filter) {
        SubjectInheritanceGraph graph = SubjectInheritanceGraphs.getGraph(filter);
        Iterable<CalculatedSubject> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this);
        for (CalculatedSubject subject : traversal) {
            for (Map.Entry<String, String> entry : subject.getCombinedOptions(filter).entrySet()) {
                accumulator.accumulateMeta(entry.getKey(), entry.getValue());
            }
        }
    }

    public void resolveAllOptions(MetaAccumulator accumulator) {
        SubjectInheritanceGraph graph = SubjectInheritanceGraphs.getGraph();
        Iterable<CalculatedSubject> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this);
        for (CalculatedSubject subject : traversal) {
            for (Map.Entry<String, String> entry : subject.getCombinedOptions().entrySet()) {
                accumulator.accumulateMeta(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Tristate getPermissionValue(ImmutableContextSet contexts, String permission) {
        Contexts lookupContexts = Contexts.of(contexts, Contexts.global().getSettings());
        return this.cachedData.getPermissionData(lookupContexts).getPermissionValue(permission, CheckOrigin.INTERNAL);
    }

    @Override
    public boolean isChildOf(ImmutableContextSet contexts, LPSubjectReference parent) {
        return this.resolveAllParents(contexts).contains(parent);
    }

    @Override
    public ImmutableList<LPSubjectReference> getParents(ImmutableContextSet contexts) {
        return ImmutableList.copyOf(this.resolveAllParents(contexts));
    }

    @Override
    public Optional<String> getOption(ImmutableContextSet contexts, String key) {
        Contexts lookupContexts = Contexts.of(contexts, Contexts.global().getSettings());
        Map<String, String> meta = this.cachedData.getMetaData(lookupContexts).getMeta();
        return Optional.ofNullable(meta.get(key));
    }

    @Override
    public void performCleanup() {
        this.cachedData.doCacheCleanup();
    }

    @Override
    public void invalidateCaches() {
        this.cachedData.invalidate();
    }
}

