/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.proxy.api7;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.contexts.ContextManager;
import me.lucko.luckperms.common.contexts.ContextsSupplier;
import me.lucko.luckperms.sponge.service.CompatibilityUtil;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import me.lucko.luckperms.sponge.service.model.ProxiedSubject;
import me.lucko.luckperms.sponge.service.proxy.api7.SubjectDataProxy;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;

public final class SubjectProxy
implements Subject,
ProxiedSubject {
    private final LPPermissionService service;
    private final LPSubjectReference ref;
    private ContextsSupplier contextsSupplier;

    public SubjectProxy(LPPermissionService service, LPSubjectReference ref) {
        this.service = service;
        this.ref = ref;
    }

    private CompletableFuture<LPSubject> handle() {
        return this.ref.resolveLp();
    }

    private ContextsSupplier getContextsCache() {
        if (this.contextsSupplier == null) {
            ContextManager<?> contextManager = this.service.getPlugin().getContextManager();
            this.contextsSupplier = contextManager.getCacheFor(this);
        }
        return this.contextsSupplier;
    }

    @Override
    public @NonNull LPSubjectReference asSubjectReference() {
        return this.ref;
    }

    public @NonNull Optional<CommandSource> getCommandSource() {
        return (Optional)((CompletableFuture)this.handle().thenApply(LPSubject::getCommandSource)).join();
    }

    public @NonNull SubjectCollection getContainingCollection() {
        return this.service.getCollection(this.ref.getCollectionIdentifier()).sponge();
    }

    public boolean isSubjectDataPersisted() {
        return true;
    }

    public SubjectData getSubjectData() {
        return new SubjectDataProxy(this.service, this.ref, true);
    }

    public SubjectData getTransientSubjectData() {
        return new SubjectDataProxy(this.service, this.ref, false);
    }

    public boolean hasPermission(@NonNull Set<Context> contexts, @NonNull String permission) {
        return (Boolean)((CompletableFuture)this.handle().thenApply(handle -> handle.getPermissionValue(CompatibilityUtil.convertContexts(contexts), permission).asBoolean())).join();
    }

    public boolean hasPermission(@NonNull String permission) {
        return (Boolean)((CompletableFuture)this.handle().thenApply(handle -> handle.getPermissionValue(ImmutableContextSet.empty(), permission).asBoolean())).join();
    }

    public @NonNull Tristate getPermissionValue(@NonNull Set<Context> contexts, @NonNull String permission) {
        return (Tristate)((CompletableFuture)this.handle().thenApply(handle -> CompatibilityUtil.convertTristate(handle.getPermissionValue(CompatibilityUtil.convertContexts(contexts), permission)))).join();
    }

    public boolean isChildOf(@NonNull SubjectReference parent) {
        return (Boolean)((CompletableFuture)this.handle().thenApply(handle -> handle.isChildOf(ImmutableContextSet.empty(), this.service.getReferenceFactory().obtain(parent)))).join();
    }

    public boolean isChildOf(@NonNull Set<Context> contexts, @NonNull SubjectReference parent) {
        return (Boolean)((CompletableFuture)this.handle().thenApply(handle -> handle.isChildOf(CompatibilityUtil.convertContexts(contexts), this.service.getReferenceFactory().obtain(parent)))).join();
    }

    public @NonNull List<SubjectReference> getParents() {
        return (List)((CompletableFuture)this.handle().thenApply(handle -> handle.getParents(ImmutableContextSet.empty()))).join();
    }

    public @NonNull List<SubjectReference> getParents(@NonNull Set<Context> contexts) {
        return (List)((CompletableFuture)this.handle().thenApply(handle -> handle.getParents(CompatibilityUtil.convertContexts(contexts)))).join();
    }

    public @NonNull Optional<String> getOption(@NonNull Set<Context> contexts, @NonNull String key) {
        return (Optional)((CompletableFuture)this.handle().thenApply(handle -> handle.getOption(CompatibilityUtil.convertContexts(contexts), key))).join();
    }

    public @NonNull Optional<String> getOption(@NonNull String key) {
        return (Optional)((CompletableFuture)this.handle().thenApply(handle -> handle.getOption(ImmutableContextSet.empty(), key))).join();
    }

    public String getIdentifier() {
        return this.ref.getSubjectIdentifier();
    }

    public @NonNull Optional<String> getFriendlyIdentifier() {
        return (Optional)((CompletableFuture)this.handle().thenApply(LPSubject::getFriendlyIdentifier)).join();
    }

    public @NonNull Set<Context> getActiveContexts() {
        return CompatibilityUtil.convertContexts(this.getContextsCache().getContextSet());
    }

    @Override
    public ImmutableContextSet getActiveContextSet() {
        return this.getContextsCache().getContextSet();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SubjectProxy && this.ref.equals(((SubjectProxy)o).ref);
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public String toString() {
        return "luckperms.api7.SubjectProxy(ref=" + this.ref + ")";
    }
}

