/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.engines;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.engines.ModuleEngine;

public abstract class ModuleSolarBase
extends ModuleEngine {
    private int light;
    private boolean maxLight;
    private int panelCoolDown;
    protected boolean down = true;
    private boolean upState;
    private boolean setup;
    private DataParameter<Integer> LIGHT;
    private DataParameter<Boolean> UP_STATE;
    private DataParameter<Integer> PRIORITY;

    public ModuleSolarBase(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    protected DataParameter<Integer> getPriorityDw() {
        return this.PRIORITY;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public void update() {
        super.update();
        this.updateSolarModel();
    }

    @Override
    protected void loadFuel() {
        this.updateLight();
        this.updateDataForModel();
        this.chargeSolar();
    }

    @Override
    public int getTotalFuel() {
        return this.getFuelLevel();
    }

    @Override
    public float[] getGuiBarColor() {
        return new float[]{1.0f, 1.0f, 0.0f};
    }

    private void updateLight() {
        if (!this.getCart().field_70170_p.func_72935_r() || this.getCart().field_70170_p.func_72896_J()) {
            this.light = 0;
        } else {
            this.light = this.getCart().field_70170_p.func_175642_b(EnumSkyBlock.SKY, this.getCart().func_180425_c());
            if (this.light == 15 && !this.getCart().field_70170_p.func_175710_j(this.getCart().func_180425_c())) {
                this.light = 14;
            }
        }
    }

    private void updateDataForModel() {
        if (this.isPlaceholder()) {
            this.light = this.getSimInfo().getMaxLight() ? 15 : 14;
        } else if (this.getCart().field_70170_p.field_72995_K) {
            this.light = this.getDw(this.LIGHT);
        } else {
            this.updateDw(this.LIGHT, this.light);
        }
        boolean bl = this.maxLight = this.light == 15;
        if (!this.upState && this.light == 15) {
            this.light = 14;
        }
    }

    private void chargeSolar() {
        if (this.light == 15 && this.getCart().field_70170_p.field_73012_v.nextInt(8) < 4) {
            this.setFuelLevel(this.getFuelLevel() + this.getGenSpeed());
            if (this.getFuelLevel() > this.getMaxCapacity()) {
                this.setFuelLevel(this.getMaxCapacity());
            }
        }
    }

    public int getLight() {
        return this.light;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ENGINES.SOLAR.translate(new String[0]), 8, 6, 0x404040);
        String strfuel = Localization.MODULES.ENGINES.NO_POWER.translate(new String[0]);
        if (this.getFuelLevel() > 0) {
            strfuel = Localization.MODULES.ENGINES.POWER.translate(String.valueOf(this.getFuelLevel()));
        }
        this.drawString(gui, strfuel, 8, 42, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        super.drawBackground(gui, x, y);
        ResourceHelper.bindResource("/gui/solar.png");
        int lightWidth = this.light * 3;
        if (this.light == 15) {
            lightWidth += 2;
        }
        this.drawImage(gui, 9, 20, 0, 0, 54, 18);
        this.drawImage(gui, 15, 21, 0, 18, lightWidth, 16);
    }

    @Override
    public int numberOfDataWatchers() {
        return super.numberOfDataWatchers() + 2;
    }

    @Override
    public void initDw() {
        this.PRIORITY = this.createDw(DataSerializers.field_187192_b);
        super.initDw();
        this.LIGHT = this.createDw(DataSerializers.field_187192_b);
        this.UP_STATE = this.createDw(DataSerializers.field_187198_h);
        this.registerDw(this.LIGHT, 0);
        this.registerDw(this.UP_STATE, false);
    }

    protected boolean isGoingDown() {
        return this.down;
    }

    public void updateSolarModel() {
        if (this.getCart().func_130014_f_().field_72995_K) {
            this.updateDataForModel();
            if (this.UP_STATE != null && !this.setup) {
                boolean tmpUp = this.getDw(this.UP_STATE);
                if (tmpUp) {
                    this.setAnimDone();
                    this.upState = true;
                    this.down = false;
                }
                this.setup = true;
            }
        }
        this.panelCoolDown += this.maxLight ? 1 : -1;
        if (this.down && this.panelCoolDown < 0) {
            this.panelCoolDown = 0;
        } else if (!this.down && this.panelCoolDown > 0) {
            this.panelCoolDown = 0;
        } else if (Math.abs(this.panelCoolDown) > 20) {
            this.panelCoolDown = 0;
            this.down = !this.down;
        }
        this.upState = this.updatePanels();
        if (!this.getCart().field_70170_p.field_72995_K) {
            this.updateDw(this.UP_STATE, this.upState);
        }
    }

    @Override
    public int numberOfGuiData() {
        return 2;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)(this.getFuelLevel() & 0xFFFF));
        this.updateGuiData(info, 1, (short)(this.getFuelLevel() >> 16 & 0xFFFF));
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            int dataint = data;
            if (dataint < 0) {
                dataint += 65536;
            }
            this.setFuelLevel(this.getFuelLevel() & 0xFFFF0000 | dataint);
        } else if (id == 1) {
            this.setFuelLevel(this.getFuelLevel() & 0xFFFF | data << 16);
        }
    }

    protected abstract int getMaxCapacity();

    protected abstract int getGenSpeed();

    protected abstract boolean updatePanels();

    protected abstract void setAnimDone();

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.func_74768_a(this.generateNBTName("Fuel", id), this.getFuelLevel());
        tagCompound.func_74757_a(this.generateNBTName("Up", id), this.upState);
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        super.Load(tagCompound, id);
        this.setFuelLevel(tagCompound.func_74762_e(this.generateNBTName("Fuel", id)));
        this.upState = tagCompound.func_74767_n(this.generateNBTName("Up", id));
        if (this.upState) {
            this.setAnimDone();
        }
    }
}

