/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid;

import com.google.common.primitives.Ints;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.container.ContainerCraftingSettings;
import com.raoulvdberge.refinedstorage.gui.GuiAmountSpecifying;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackFluid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingPreview;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiGridCraftingSettings
extends GuiAmountSpecifying {
    private IGridStack stack;

    public GuiGridCraftingSettings(GuiBase parent, EntityPlayer player, IGridStack stack) {
        super(parent, new ContainerCraftingSettings(player, stack), 172, 99);
        this.stack = stack;
    }

    @Override
    protected String getOkButtonText() {
        return GuiGridCraftingSettings.t("misc.refinedstorage:start", new Object[0]);
    }

    @Override
    protected String getTitle() {
        return GuiGridCraftingSettings.t("container.crafting", new Object[0]);
    }

    @Override
    protected String getTexture() {
        return "gui/crafting_settings.png";
    }

    @Override
    protected int[] getIncrements() {
        if (this.stack instanceof GridStackFluid) {
            return new int[]{100, 500, 1000, -100, -500, -1000};
        }
        return new int[]{1, 10, 64, -1, -10, -64};
    }

    @Override
    protected int getDefaultAmount() {
        return this.stack instanceof GridStackFluid ? 1000 : 1;
    }

    @Override
    protected boolean canAmountGoNegative() {
        return false;
    }

    @Override
    protected int getMaxAmount() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void onOkButtonPressed(boolean shiftDown) {
        Integer quantity = Ints.tryParse((String)this.amountField.func_146179_b());
        if (quantity != null && quantity > 0) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridCraftingPreview(this.stack.getHash(), quantity, shiftDown, this.stack instanceof GridStackFluid));
            this.okButton.field_146124_l = false;
        }
    }
}

