/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.data;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.network.MessageTileDataParameterUpdate;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.tile.data.TileDataWatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileDataManager {
    private static int LAST_ID = 0;
    private static Map<Integer, TileDataParameter> REGISTRY = new HashMap<Integer, TileDataParameter>();
    private TileEntity tile;
    private List<TileDataParameter> parameters = new ArrayList<TileDataParameter>();
    private List<TileDataParameter> watchedParameters = new ArrayList<TileDataParameter>();
    private List<TileDataWatcher> watchers = new CopyOnWriteArrayList<TileDataWatcher>();

    public TileDataManager(TileEntity tile) {
        this.tile = tile;
    }

    public TileEntity getTile() {
        return this.tile;
    }

    public void addParameter(TileDataParameter parameter) {
        this.parameters.add(parameter);
    }

    public List<TileDataParameter> getParameters() {
        return this.parameters;
    }

    public void addWatchedParameter(TileDataParameter parameter) {
        this.addParameter(parameter);
        this.watchedParameters.add(parameter);
    }

    public List<TileDataParameter> getWatchedParameters() {
        return this.watchedParameters;
    }

    public void addWatcher(TileDataWatcher listener) {
        this.watchers.add(listener);
    }

    public void removeWatcher(TileDataWatcher listener) {
        this.watchers.remove(listener);
    }

    public void sendParameterToWatchers(TileDataParameter parameter) {
        this.watchers.forEach(l -> l.sendParameter(false, parameter));
    }

    public static void registerParameter(TileDataParameter parameter) {
        parameter.setId(LAST_ID);
        REGISTRY.put(LAST_ID++, parameter);
    }

    public static TileDataParameter getParameter(int id) {
        return REGISTRY.get(id);
    }

    public static void setParameter(TileDataParameter parameter, Object value) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageTileDataParameterUpdate(parameter, value));
    }
}

