/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import javax.annotation.Nullable;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class TurbineFluidTank
implements IFluidTank {
    public TileEntityTurbineCasing turbine;

    public TurbineFluidTank(TileEntityTurbineCasing tileEntity) {
        this.turbine = tileEntity;
    }

    @Nullable
    public FluidStack getFluid() {
        return this.turbine.structure != null ? ((SynchronizedTurbineData)this.turbine.structure).fluidStored : null;
    }

    public int getCapacity() {
        return this.turbine.structure != null ? ((SynchronizedTurbineData)this.turbine.structure).getFluidCapacity() : 0;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.turbine.structure != null && !this.turbine.func_145831_w().field_72995_K) {
            if (resource == null || resource.getFluid() == null) {
                return 0;
            }
            if (((SynchronizedTurbineData)this.turbine.structure).fluidStored != null && !((SynchronizedTurbineData)this.turbine.structure).fluidStored.isFluidEqual(resource)) {
                return 0;
            }
            if (((SynchronizedTurbineData)this.turbine.structure).fluidStored == null || ((SynchronizedTurbineData)this.turbine.structure).fluidStored.getFluid() == null) {
                if (resource.amount <= this.getCapacity()) {
                    if (doFill) {
                        ((SynchronizedTurbineData)this.turbine.structure).fluidStored = resource.copy();
                        if (resource.amount > 0) {
                            MekanismUtils.saveChunk((TileEntity)this.turbine);
                        }
                    }
                    return resource.amount;
                }
                if (doFill) {
                    ((SynchronizedTurbineData)this.turbine.structure).fluidStored = resource.copy();
                    ((SynchronizedTurbineData)this.turbine.structure).fluidStored.amount = this.getCapacity();
                    if (this.getCapacity() > 0) {
                        MekanismUtils.saveChunk((TileEntity)this.turbine);
                    }
                }
                return this.getCapacity();
            }
            if (resource.amount <= this.getNeeded()) {
                if (doFill) {
                    ((SynchronizedTurbineData)this.turbine.structure).fluidStored.amount += resource.amount;
                    if (resource.amount > 0) {
                        MekanismUtils.saveChunk((TileEntity)this.turbine);
                    }
                }
                return resource.amount;
            }
            int prevNeeded = this.getNeeded();
            if (doFill) {
                ((SynchronizedTurbineData)this.turbine.structure).fluidStored.amount = this.getCapacity();
                if (prevNeeded > 0) {
                    MekanismUtils.saveChunk((TileEntity)this.turbine);
                }
            }
            return prevNeeded;
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.turbine.structure != null && !this.turbine.func_145831_w().field_72995_K) {
            if (((SynchronizedTurbineData)this.turbine.structure).fluidStored == null || ((SynchronizedTurbineData)this.turbine.structure).fluidStored.getFluid() == null) {
                return null;
            }
            if (((SynchronizedTurbineData)this.turbine.structure).fluidStored.amount <= 0) {
                return null;
            }
            int used = maxDrain;
            if (((SynchronizedTurbineData)this.turbine.structure).fluidStored.amount < used) {
                used = ((SynchronizedTurbineData)this.turbine.structure).fluidStored.amount;
            }
            if (doDrain) {
                ((SynchronizedTurbineData)this.turbine.structure).fluidStored.amount -= used;
            }
            FluidStack drained = new FluidStack(((SynchronizedTurbineData)this.turbine.structure).fluidStored.getFluid(), used);
            if (((SynchronizedTurbineData)this.turbine.structure).fluidStored.amount <= 0) {
                ((SynchronizedTurbineData)this.turbine.structure).fluidStored = null;
            }
            if (drained.amount > 0 && doDrain) {
                MekanismUtils.saveChunk((TileEntity)this.turbine);
                this.turbine.sendPacketToRenderer();
            }
            return drained;
        }
        return null;
    }

    public int getNeeded() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public int getFluidAmount() {
        if (this.turbine.structure != null && ((SynchronizedTurbineData)this.turbine.structure).fluidStored != null) {
            return ((SynchronizedTurbineData)this.turbine.structure).fluidStored.amount;
        }
        return 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }
}

