/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import tinker_io.config.TinkerIOConfig;
import tinker_io.fluids.FluidTankWithTile;
import tinker_io.handler.EnumHandler;
import tinker_io.handler.SmartOutputRecipeHandler;
import tinker_io.registry.ItemRegistry;
import tinker_io.tileentity.TileEntityItemCapacity;

public class TileEntitySmartOutput
extends TileEntityItemCapacity
implements ITickable {
    public static final String TAG_CURRENT_MODE = "currentMode";
    public static final String TAG_PROGRESS = "progress";
    public static final String TAG_MAX_OUTPUT_STACK_SIZE = "maxOutputStackSize";
    public static final String TAG_TARGET_ITEM_STACK = "targetItemStack";
    public static final int CAPACITY = 10000;
    private static final int PROGRESS_MAX = TinkerIOConfig.CONFIG_TINKER_IO.SmartOutputSpeed;
    public static final int MODE_CAST = 0;
    public static final int MODE_BASIN = 1;
    private static final int SLOTS_SIZE = 4;
    private FluidTank tank;
    private int tick = 0;
    private int progress;
    private int maxOutputStackSize = 0;
    private int currentMode = 0;
    private boolean controlledByRedstone = false;
    private boolean blockPowered = false;
    private ICastingRecipe currentRecipe;
    private ItemStack targetItemStack = ItemStack.field_190927_a;
    private int lastMode = 0;
    private FluidStack lastFluidStack;
    private ItemStack lastCast = ItemStack.field_190927_a;

    public TileEntitySmartOutput() {
        super(4);
        this.tank = new FluidTankWithTile(this, 10000);
    }

    @Override
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot == 0) {
            return this.inventory.insertItem(slot, stack, simulate);
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 1) {
            return this.inventory.extractItem(slot, amount, simulate);
        }
        return super.extractItem(slot, amount, simulate);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tick % 2 == 0) {
            this.checkUpgrade();
            this.blockPowered = this.field_145850_b.func_175640_z(this.field_174879_c);
            if (this.isChanged()) {
                this.updateRecipe();
            }
            if (this.canWork()) {
                this.doCasting();
            }
        }
        this.tick = (this.tick + 1) % 200;
    }

    private void updateRecipe() {
        ItemStack cast = this.inventory.getStackInSlot(0);
        FluidStack fluidStack = this.tank.getFluid();
        if (this.currentMode == 1) {
            this.currentRecipe = SmartOutputRecipeHandler.findBasinCastingRecipe(cast, fluidStack);
        } else if (this.currentMode == 0) {
            this.currentRecipe = SmartOutputRecipeHandler.findTableCastingRecipe(cast, fluidStack);
        }
    }

    private void doCasting() {
        if (this.progress == 0) {
            if (this.targetItemStack.func_190926_b() && this.currentRecipe != null) {
                ItemStack cast = this.inventory.getStackInSlot(0);
                FluidStack fluidStack = this.tank.getFluid();
                if (fluidStack != null && fluidStack.amount >= this.currentRecipe.getFluidAmount()) {
                    this.targetItemStack = this.getResult(cast, fluidStack);
                    if (!this.targetItemStack.func_190926_b() && this.canOutput()) {
                        if (this.currentRecipe.consumesCast()) {
                            this.inventory.extractItem(0, 1, false);
                        }
                        this.tank.drain(this.currentRecipe.getFluidAmount(), true);
                        ++this.progress;
                        this.func_70296_d();
                    } else {
                        this.targetItemStack = ItemStack.field_190927_a;
                    }
                }
            }
        } else {
            if (this.progress >= PROGRESS_MAX - 1) {
                this.inventory.insertItem(1, this.targetItemStack, false);
                this.targetItemStack = ItemStack.field_190927_a;
                this.progress = 0;
            } else {
                this.progress = (this.progress + 1) % PROGRESS_MAX;
            }
            this.func_70296_d();
        }
    }

    private ItemStack getResult(ItemStack cast, FluidStack fluidStack) {
        if (fluidStack != null) {
            return this.currentRecipe.getResult(cast, fluidStack.getFluid());
        }
        return ItemStack.field_190927_a;
    }

    private boolean canOutput() {
        ItemStack productSlot = this.inventory.getStackInSlot(1);
        return (productSlot.func_190926_b() || productSlot.func_77969_a(this.targetItemStack) && ItemStack.func_77970_a((ItemStack)productSlot, (ItemStack)this.targetItemStack)) && this.maxOutputStackSize - productSlot.func_190916_E() > 0;
    }

    private boolean isChanged() {
        FluidStack fluidStack = this.tank.getFluid();
        ItemStack itemStack = this.inventory.getStackInSlot(0);
        boolean changed = this.lastMode != this.currentMode || this.lastFluidStack != null && fluidStack == null || this.lastFluidStack == null && fluidStack != null || fluidStack != null && !fluidStack.isFluidEqual(this.lastFluidStack) || fluidStack != null && !FluidStack.areFluidStackTagsEqual((FluidStack)this.lastFluidStack, (FluidStack)fluidStack) || !ItemStack.func_179545_c((ItemStack)this.lastCast, (ItemStack)itemStack) || !ItemStack.func_77970_a((ItemStack)this.lastCast, (ItemStack)itemStack);
        this.lastMode = this.currentMode;
        this.lastFluidStack = fluidStack;
        this.lastCast = itemStack;
        return changed;
    }

    private void checkUpgrade() {
        ItemStack stackUp = this.inventory.getStackInSlot(2);
        ItemStack stackDown = this.inventory.getStackInSlot(3);
        this.maxOutputStackSize = 1;
        this.controlledByRedstone = false;
        this.currentMode = 0;
        this.checkUpgrade(stackUp);
        this.checkUpgrade(stackDown);
        if (this.maxOutputStackSize > 64) {
            this.maxOutputStackSize = 64;
        }
    }

    private void checkUpgrade(ItemStack itemStack) {
        if (itemStack != ItemStack.field_190927_a && itemStack.func_77973_b().equals((Object)ItemRegistry.upgrade)) {
            this.maxOutputStackSize += this.getSlotExpendSize(itemStack);
            if (itemStack.func_77969_a(new ItemStack((Item)ItemRegistry.upgrade, 1, EnumHandler.ItemUpgradeTypes.REDETONE_UPG.getID()))) {
                this.controlledByRedstone = true;
            }
            if (itemStack.func_77969_a(new ItemStack((Item)ItemRegistry.upgrade, 1, EnumHandler.ItemUpgradeTypes.BASIN_UPGRADE.getID()))) {
                this.currentMode = 1;
            }
        }
    }

    private int getSlotExpendSize(ItemStack itemStack) {
        int size = 0;
        int meta = itemStack.func_77952_i();
        int count = itemStack.func_190916_E();
        if (meta == EnumHandler.ItemUpgradeTypes.SLOT_UPG_1.getID()) {
            size = count * 1;
        } else if (meta == EnumHandler.ItemUpgradeTypes.SLOT_UPG_2.getID()) {
            size = count * 2;
        } else if (meta == EnumHandler.ItemUpgradeTypes.SLOT_UPG_3.getID()) {
            size = count * 3;
        } else if (meta == EnumHandler.ItemUpgradeTypes.SLOT_UPG_4.getID()) {
            size = count * 4;
        }
        return size;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
        this.currentMode = tag.func_74762_e(TAG_CURRENT_MODE);
        this.progress = tag.func_74762_e(TAG_PROGRESS);
        this.maxOutputStackSize = tag.func_74762_e(TAG_MAX_OUTPUT_STACK_SIZE);
        this.targetItemStack = new ItemStack(tag.func_74775_l(TAG_TARGET_ITEM_STACK));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.tank.writeToNBT(tag);
        tag.func_74768_a(TAG_CURRENT_MODE, this.currentMode);
        tag.func_74768_a(TAG_PROGRESS, this.progress);
        tag.func_74768_a(TAG_MAX_OUTPUT_STACK_SIZE, this.maxOutputStackSize);
        NBTTagCompound tagItemStack = new NBTTagCompound();
        tagItemStack = this.targetItemStack.func_77955_b(tagItemStack);
        tag.func_74782_a(TAG_TARGET_ITEM_STACK, (NBTBase)tagItemStack);
        return tag;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int getFluidAmount() {
        if (this.getFluid() != null) {
            return this.getFluid().amount;
        }
        return 0;
    }

    public void emptyTank() {
        this.tank.drain(this.getFluidAmount(), true);
        this.func_70296_d();
    }

    public ItemStack getTargetItemStack() {
        return this.targetItemStack;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public int getMaxOutputStackSize() {
        return this.maxOutputStackSize;
    }

    public boolean isControlledByRedstone() {
        return this.controlledByRedstone;
    }

    public boolean isBlockPowered() {
        return this.blockPowered;
    }

    public boolean canWork() {
        if (!this.controlledByRedstone) {
            return true;
        }
        return !this.blockPowered;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFluidBarHeight(int pixel) {
        return (int)((float)this.tank.getFluidAmount() / 10000.0f * (float)pixel);
    }

    @SideOnly(value=Side.CLIENT)
    public int getProgress(int pixel) {
        return (int)((float)pixel * (float)this.progress / (float)PROGRESS_MAX);
    }
}

