/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.client.ClientHandler;
import pregenerator.impl.client.infos.InfoEntry;
import pregenerator.impl.processor.ChunkProcessor;

public class AnswerPacket
extends PregenPacket {
    List<InfoEntry> entries = new ArrayList<InfoEntry>();
    boolean processing;

    public AnswerPacket() {
    }

    public AnswerPacket(List<InfoEntry> list) {
        this.processing = ChunkProcessor.INSTANCE.isRunning();
        this.entries.addAll(list);
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.processing = buffer.readBoolean();
        if (!this.processing) {
            return;
        }
        int amount = buffer.readByte();
        for (int i = 0; i < amount; ++i) {
            InfoEntry entry = InfoEntry.getByID(buffer.readByte());
            if (entry == null) continue;
            entry.read(buffer);
        }
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeBoolean(this.processing);
        if (!this.processing) {
            return;
        }
        buffer.writeByte(this.entries.size());
        for (InfoEntry entry : this.entries) {
            buffer.writeByte(entry.getID());
            entry.write(buffer);
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        this.handleClient();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        ClientHandler.INSTANCE.info.running = this.processing;
    }
}

