/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile;

import icbm.classic.content.missile.EntityMissile;
import icbm.classic.content.missile.MissileTrackerWorld;
import java.util.HashMap;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="icbmclassic")
public class MissileTrackerHandler {
    public static final String DATA_SAVE_ID = "icbmclassicMissileTracker";
    public static final HashMap<Integer, MissileTrackerWorld> dimToHandlerMap = new HashMap();

    public static void simulateMissile(EntityMissile missile) {
        MissileTrackerHandler.getHandler(missile.field_70170_p, true).simulateMissile(missile);
    }

    public static MissileTrackerWorld getHandler(World world, boolean create) {
        if (dimToHandlerMap.containsKey(world.field_73011_w.getDimension())) {
            return dimToHandlerMap.get(world.field_73011_w.getDimension());
        }
        MissileTrackerWorld instance = (MissileTrackerWorld)world.getPerWorldStorage().func_75742_a(MissileTrackerWorld.class, DATA_SAVE_ID);
        if (create) {
            if (instance == null) {
                instance = new MissileTrackerWorld(DATA_SAVE_ID);
                world.getPerWorldStorage().func_75745_a(DATA_SAVE_ID, (WorldSavedData)instance);
            }
            dimToHandlerMap.put(world.field_73011_w.getDimension(), instance);
        }
        return instance;
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        MissileTrackerWorld handler;
        if (!event.getWorld().field_72995_K && (handler = MissileTrackerHandler.getHandler(event.getWorld(), false)) != null) {
            handler.destroy();
            dimToHandlerMap.remove(event.getWorld().field_73011_w.getDimension());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        MissileTrackerWorld handler;
        if (!event.world.field_72995_K && (handler = MissileTrackerHandler.getHandler(event.world, false)) != null) {
            handler.onWorldTick(event.world);
        }
    }
}

