/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw;

import com.gmail.trentech.pjw.commands.CommandWorld;
import com.gmail.trentech.pjw.extra.OceanWorldGeneratorModifier;
import com.gmail.trentech.pjw.init.Common;
import com.gmail.trentech.pjw.io.Migrator;
import com.gmail.trentech.pjw.listeners.EventManager;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameConstructionEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;

@Plugin(id="pjw", name="ProjectWorlds", version="0.12.2", description="Multi world management plugin", authors={"TrenTech"}, url="http://github.com/TrenTech/ProjectWorlds", dependencies={@Dependency(id="pjc", optional=false)})
public class Main {
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path path;
    @Inject
    private Logger log;
    private static PluginContainer plugin;
    private static Main instance;

    @Listener
    public void onGameConstructionEvent(GameConstructionEvent event) {
        plugin = (PluginContainer)Sponge.getPluginManager().getPlugin("pjw").get();
        instance = this;
        try {
            Files.createDirectories(this.path, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Common.initConfig();
        Migrator.init();
    }

    @Listener
    public void onInitialization(GameInitializationEvent event) {
        Sponge.getEventManager().registerListeners((Object)this, (Object)new EventManager());
        Sponge.getRegistry().register(WorldGeneratorModifier.class, (CatalogType)new OceanWorldGeneratorModifier());
        Common.initHelp();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)new CommandWorld().getCommandSpec(), new String[]{"world", "w"});
    }

    public Logger getLog() {
        return this.log;
    }

    public Path getPath() {
        return this.path;
    }

    public static PluginContainer getPlugin() {
        return plugin;
    }

    public static Main instance() {
        return instance;
    }
}

