/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.shops.data;

import com.erigitic.shops.ShopItem;
import com.erigitic.shops.data.ImmutableShopItemData;
import com.erigitic.shops.data.ShopKeys;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.mutable.Value;

public class ShopItemData
extends AbstractSingleData<ShopItem, ShopItemData, ImmutableShopItemData> {
    public static final int CONTENT_VERSION = 1;

    public ShopItemData() {
        super(null, ShopKeys.SHOP_ITEM);
    }

    public ShopItemData(ShopItem shopItem) {
        super((Object)shopItem, ShopKeys.SHOP_ITEM);
    }

    public ShopItemData copy() {
        return new ShopItemData((ShopItem)this.getValue());
    }

    public ImmutableShopItemData asImmutable() {
        return new ImmutableShopItemData((ShopItem)this.getValue());
    }

    public int getContentVersion() {
        return 1;
    }

    public Optional<ShopItemData> from(DataContainer container) {
        Optional shopItemOpt;
        if (container.contains(ShopKeys.SHOP_ITEM.getQuery()) && (shopItemOpt = container.getSerializable(ShopKeys.SHOP_ITEM.getQuery(), ShopItem.class)).isPresent()) {
            Optional<ShopItemData> shopItemDataOpt = Optional.of(new ShopItemData((ShopItem)shopItemOpt.get()));
            return shopItemDataOpt;
        }
        return Optional.empty();
    }

    public Optional<ShopItemData> fill(DataHolder dataHolder, MergeFunction overlap) {
        ShopItemData shopItemData = (ShopItemData)((MergeFunction)Preconditions.checkNotNull((Object)overlap)).merge((ValueContainer)this.copy(), (ValueContainer)dataHolder.get(ShopItemData.class).orElse(this.copy()));
        return Optional.of(this.set(ShopKeys.SHOP_ITEM, shopItemData.get(ShopKeys.SHOP_ITEM).get()));
    }

    protected Value<ShopItem> getValueGetter() {
        return Sponge.getRegistry().getValueFactory().createValue(ShopKeys.SHOP_ITEM, this.getValue(), this.getValue());
    }

    public DataContainer toContainer() {
        return super.toContainer().set(ShopKeys.SHOP_ITEM, this.getValue());
    }

    public static class Builder
    extends AbstractDataBuilder<ShopItemData>
    implements DataManipulatorBuilder<ShopItemData, ImmutableShopItemData> {
        public Builder() {
            super(ShopItemData.class, 1);
        }

        public Optional<ShopItemData> buildContent(DataView container) throws InvalidDataException {
            Optional shopItemOpt;
            if (container.contains(ShopKeys.SHOP_ITEM.getQuery()) && (shopItemOpt = container.getSerializable(ShopKeys.SHOP_ITEM.getQuery(), ShopItem.class)).isPresent()) {
                Optional<ShopItemData> shopItemDataOpt = Optional.of(new ShopItemData((ShopItem)shopItemOpt.get()));
                return shopItemDataOpt;
            }
            return Optional.empty();
        }

        public ShopItemData create() {
            return new ShopItemData();
        }

        public Optional<ShopItemData> createFrom(DataHolder dataHolder) {
            return this.create().fill(dataHolder);
        }

        public ShopItemData createFrom(ShopItem shopItem) {
            return new ShopItemData(shopItem);
        }
    }
}

