/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile;

import java.util.Random;
import nc.block.tile.BlockTile;
import nc.block.tile.IActivatable;
import nc.block.tile.ITileType;
import nc.enumm.BlockEnums;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockActivatable
extends BlockTile
implements IActivatable,
ITileType {
    protected final boolean isActive;
    protected final BlockEnums.ActivatableTileType type;

    public BlockActivatable(BlockEnums.ActivatableTileType type, boolean isActive) {
        super(Material.field_151573_f);
        this.isActive = isActive;
        if (!isActive) {
            this.func_149647_a(type.getTab());
        }
        this.type = type;
    }

    @Override
    public String getTileName() {
        return this.type.func_176610_l() + (this.isActive ? "_active" : "_idle");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.type.getTile();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.type.getIdleBlock());
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(this.type.getIdleBlock());
    }

    @Override
    public Block getBlockType(boolean active) {
        return active ? this.type.getActiveBlock() : this.type.getIdleBlock();
    }

    @Override
    public void setState(boolean isActive, TileEntity tile) {
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        keepInventory = true;
        if (isActive) {
            world.func_180501_a(pos, this.type.getActiveBlock().func_176223_P(), 3);
        } else {
            world.func_180501_a(pos, this.type.getIdleBlock().func_176223_P(), 3);
        }
        keepInventory = false;
        tile.func_145829_t();
        world.func_175690_a(pos, tile);
    }

    public static class Transparent
    extends BlockActivatable {
        protected final boolean smartRender;

        public Transparent(BlockEnums.ActivatableTileType type, boolean isActive, boolean smartRender) {
            super(type, isActive);
            this.func_149711_c(1.5f);
            this.func_149752_b(10.0f);
            this.smartRender = smartRender;
        }

        @SideOnly(value=Side.CLIENT)
        public BlockRenderLayer func_180664_k() {
            return BlockRenderLayer.CUTOUT;
        }

        public boolean func_149686_d(IBlockState state) {
            return false;
        }

        public boolean func_149662_c(IBlockState state) {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
            if (!this.smartRender) {
                return true;
            }
            IBlockState otherState = world.func_180495_p(pos.func_177972_a(side));
            Block block = otherState.func_177230_c();
            if (blockState != otherState) {
                return true;
            }
            return block == this ? false : super.func_176225_a(blockState, world, pos, side);
        }
    }
}

