/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.dummy;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import ic2.api.energy.tile.IEnergySink;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.tile.dummy.IInterfaceable;
import nc.tile.dummy.TileDummy;
import nc.tile.energy.ITileEnergy;
import nc.tile.generator.TileFissionController;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.tile.passive.ITilePassive;
import nc.util.BlockFinder;
import nc.util.EnergyHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileFissionPort
extends TileDummy<TileFissionController>
implements IInterfaceable,
SimpleComponent {
    private BlockFinder finder;
    private InventoryConnection[] inventoryConnections = ITileInventory.inventoryConnectionAll(ItemSorption.BOTH);

    public TileFissionPort() {
        super(TileFissionController.class, "fission_port", ITileInventory.inventoryConnectionAll(ItemSorption.BOTH), ITileEnergy.energyConnectionAll(EnergyConnection.OUT), NCConfig.machine_update_rate, null);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.pushEnergy();
        }
    }

    @Override
    public void onAdded() {
        this.findController();
        super.onAdded();
    }

    @Override
    @Nonnull
    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    private int getNumberOfPorts() {
        if (this.hasMaster()) {
            return ((TileFissionController)this.getMaster()).ports;
        }
        return 1;
    }

    private int getCurrentEnergyStored() {
        if (this.hasMaster()) {
            return ((TileFissionController)this.getMaster()).currentEnergyStored;
        }
        return 1;
    }

    @Override
    public int getEUSourceTier() {
        if (this.hasMaster()) {
            return EnergyHelper.getEUTier(((TileFissionController)this.getMaster()).processPower / (double)this.getNumberOfPorts());
        }
        return 1;
    }

    @Override
    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return Math.min(Math.pow(2.0, 2 * this.getSourceTier() + 3), (double)this.getEnergyStorage().extractEnergy(this.getEnergyStorage().getMaxTransfer(), true) / (double)(this.getNumberOfPorts() * NCConfig.rf_per_eu));
    }

    @Override
    public void pushEnergy() {
        if (this.getMaster() == null || this.getEnergyStorage().getEnergyStored() <= 0) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.pushPortEnergyToSide(side);
        }
    }

    public void pushPortEnergyToSide(@Nonnull EnumFacing side) {
        IEnergyContainer adjStorageGT;
        if (this.getEnergyStorage().getEnergyStored() <= 0 || !this.getEnergyConnection(side).canExtract()) {
            return;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
        if (tile == null) {
            return;
        }
        if (tile instanceof ITileEnergy && !((ITileEnergy)tile).getEnergyConnection(side.func_176734_d()).canReceive()) {
            return;
        }
        if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushEnergyTo()) {
            return;
        }
        IEnergyStorage adjStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
        if (adjStorage != null && this.getEnergyStorage().canExtract()) {
            this.getEnergyStorage().extractEnergy(adjStorage.receiveEnergy(this.getEnergyStorage().extractEnergy(this.getCurrentEnergyStored() / this.getNumberOfPorts(), true), false), false);
            return;
        }
        if (this.getEnergyStorage().getEnergyStored() < NCConfig.rf_per_eu) {
            return;
        }
        if (ModCheck.ic2Loaded() && NCConfig.enable_ic2_eu && tile instanceof IEnergySink) {
            this.getEnergyStorage().extractEnergy((int)Math.round(((IEnergySink)tile).injectEnergy(side.func_176734_d(), (double)(this.getEnergyStorage().extractEnergy(this.getCurrentEnergyStored() / this.getNumberOfPorts(), true) / NCConfig.rf_per_eu), (double)this.getSourceTier()) * (double)NCConfig.rf_per_eu), false);
            return;
        }
        if (NCConfig.enable_gtce_eu && ModCheck.gregtechLoaded() && (adjStorageGT = (IEnergyContainer)tile.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, side.func_176734_d())) != null && this.getEnergyStorage().canExtract()) {
            int voltage = MathHelper.func_76125_a((int)(this.getCurrentEnergyStored() / this.getNumberOfPorts() / NCConfig.rf_per_eu), (int)1, (int)EnergyHelper.getMaxEUFromTier(this.getEUSourceTier()));
            this.getEnergyStorage().extractEnergy((int)Math.min((long)voltage * adjStorageGT.acceptEnergyFromNetwork(side.func_176734_d(), (long)voltage, 1L) * (long)NCConfig.rf_per_eu, Integer.MAX_VALUE), false);
            return;
        }
    }

    @Override
    public void findMaster() {
    }

    private static boolean notOrigin(int x, int y, int z) {
        return x != 0 || y != 0 || z != 0;
    }

    private boolean findCasing(int x, int y, int z) {
        return this.finder.find(x, y, z, NCBlocks.fission_block.func_176203_a(0), NCBlocks.reactor_casing_transparent, NCBlocks.fission_port, NCBlocks.buffer, NCBlocks.reactor_door, NCBlocks.reactor_trapdoor);
    }

    private boolean findCasingNotOrigin(int x, int y, int z) {
        return TileFissionPort.notOrigin(x, y, z) && this.findCasing(x, y, z);
    }

    private boolean findController(int x, int y, int z) {
        return this.finder.find(x, y, z, NCBlocks.fission_controller_new_fixed, NCBlocks.fission_controller_idle, NCBlocks.fission_controller_active, NCBlocks.fission_controller_new_idle, NCBlocks.fission_controller_new_active);
    }

    private boolean findCasingAll(int x, int y, int z) {
        return this.findCasing(x, y, z) || this.findController(x, y, z);
    }

    public void findController() {
        for (int dir = 2; dir <= 5; ++dir) {
            int y;
            int z;
            this.finder = new BlockFinder(this.field_174879_c, this.field_145850_b, dir);
            int l = NCConfig.fission_max_size + 2;
            boolean f = false;
            int rz = 0;
            int z0 = 0;
            int x0 = 0;
            int y0 = 0;
            int z1 = 0;
            int x1 = 0;
            int y1 = 0;
            for (z = 0; z <= l; ++z) {
                if (this.findCasingAll(0, 1, 0) || this.findCasingAll(0, -1, 0) || (this.findCasingAll(1, 1, 0) || this.findCasingAll(1, -1, 0)) && this.findCasingAll(1, 0, 0) || this.findCasingAll(1, 1, 0) && !this.findCasingAll(1, -1, 0) && !this.findCasingAll(1, 0, 0) || !this.findCasingAll(1, 1, 0) && this.findCasingAll(1, -1, 0) && !this.findCasingAll(1, 0, 0)) {
                    if (this.findCasingAll(0, 1, -z) && (this.findCasingAll(1, 1, -z) || this.findCasingAll(0, 1, -z + 1)) || this.findCasingAll(0, -1, -z) && (this.findCasingAll(1, -1, -z) || this.findCasingAll(0, -1, -z + 1)) || !this.findCasingAll(0, 0, -z + 1) && !this.findCasingAll(0, 1, -z + 1) && !this.findCasingAll(0, -1, -z + 1)) continue;
                    rz = l - z;
                    z0 = -z;
                    f = true;
                    break;
                }
                if (this.findCasingNotOrigin(0, 0, -z) || this.findCasing(1, 1, -z) || this.findCasing(1, -1, -z) || !this.findCasingAll(0, 0, -z + 1) || !this.findCasing(1, 0, -z) || !this.findCasing(1, 1, -z + 1) || !this.findCasing(1, -1, -z + 1)) continue;
                rz = l - z;
                z0 = -z;
                f = true;
                break;
            }
            if (!f) {
                this.masterPosition = null;
                continue;
            }
            f = false;
            for (y = 0; y <= l; ++y) {
                if (this.findCasingNotOrigin(x0, -y + 1, z0) || this.findCasing(x0 + 1, -y, z0) || this.findCasing(x0, -y, z0 + 1) || !this.findCasingAll(x0 + 1, -y, z0 + 1) || !this.findCasingAll(x0, -y + 1, z0 + 1) || !this.findCasingAll(x0 + 1, -y + 1, z0)) continue;
                y0 = -y;
                f = true;
                break;
            }
            if (!f) {
                this.masterPosition = null;
                continue;
            }
            f = false;
            for (z = 0; z <= rz; ++z) {
                if (this.findCasing(x0, y0 + 1, z) || this.findCasing(x0 + 1, y0, z) || this.findCasing(x0, y0, z - 1) || !this.findCasingAll(x0 + 1, y0, z - 1) || !this.findCasingAll(x0, y0 + 1, z - 1) || !this.findCasingAll(x0 + 1, y0 + 1, z)) continue;
                z1 = z;
                f = true;
                break;
            }
            if (!f) {
                this.masterPosition = null;
                continue;
            }
            f = false;
            for (int x = 0; x <= l; ++x) {
                if (this.findCasing(x0 + x, y0 + 1, z0) || this.findCasing(x0 + x - 1, y0, z0) || this.findCasing(x0 + x, y0, z0 + 1) || !this.findCasingAll(x0 + x - 1, y0, z0 + 1) || !this.findCasingAll(x0 + x, y0 + 1, z0 + 1) || !this.findCasingAll(x0 + x - 1, y0 + 1, z0)) continue;
                x1 = x0 + x;
                f = true;
                break;
            }
            if (!f) {
                this.masterPosition = null;
                continue;
            }
            f = false;
            for (y = 0; y <= l; ++y) {
                if (this.findCasing(x0, y0 + y - 1, z0) || this.findCasing(x0 + 1, y0 + y, z0) || this.findCasing(x0, y0 + y, z0 + 1) || !this.findCasingAll(x0 + 1, y0 + y, z0 + 1) || !this.findCasingAll(x0, y0 + y - 1, z0 + 1) || !this.findCasingAll(x0 + 1, y0 + y - 1, z0)) continue;
                y1 = y0 + y;
                f = true;
                break;
            }
            if (!f) {
                this.masterPosition = null;
                continue;
            }
            f = false;
            if (x0 > 0 || x1 < 0 || y0 > 0 || y1 < 0 || z0 > 0 || z1 < 0 || x1 - x0 < 1 || y1 - y0 < 1 || z1 - z0 < 1) {
                this.masterPosition = null;
                continue;
            }
            for (y = y0; y <= y1; ++y) {
                int x;
                for (int z2 = z0; z2 <= z1; ++z2) {
                    int[] nArray = new int[]{x0, x1};
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        x = nArray[i];
                        if (this.field_145850_b.func_175625_s(this.finder.position(x, y, z2)) == null || !this.isMaster(this.finder.position(x, y, z2))) continue;
                        this.masterPosition = this.finder.position(x, y, z2);
                        return;
                    }
                }
                for (int z3 : new int[]{z0, z1}) {
                    for (x = x0; x <= x1; ++x) {
                        if (this.field_145850_b.func_175625_s(this.finder.position(x, y, z3)) == null || !this.isMaster(this.finder.position(x, y, z3))) continue;
                        this.masterPosition = this.finder.position(x, y, z3);
                        return;
                    }
                }
            }
            this.masterPosition = null;
        }
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "nc_fission_reactor";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isComplete(Context context, Arguments args) {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.hasMaster() ? ((TileFissionController)this.getMaster()).complete == 1 : false;
        return objectArray;
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isProcessing(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).isProcessing : false};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getProblem(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).problem : TileFissionController.INVALID_STRUCTURE};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthX(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).getLengthX() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthY(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).getLengthY() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthZ(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).getLengthZ() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyStored(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).getEnergyStored() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxEnergyStored(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).getMaxEnergyStored() : 1};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyChange(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).energyChange : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getCurrentProcessTime(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).time : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getHeatLevel(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).heat : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxHeatLevel(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).getMaxHeat() : 1};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEfficiency(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).efficiency : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getHeatMultiplier(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).heatMult : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFissionFuelTime(Context context, Arguments args) {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.hasMaster() ? (this.getMaster() != null ? ((TileFissionController)this.getMaster()).baseProcessTime : 0.0) : 0.0;
        return objectArray;
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFissionFuelPower(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).baseProcessPower : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFissionFuelHeat(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).baseProcessHeat : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFissionFuelName(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).getFuelName() : TileFissionController.NO_FUEL};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorProcessTime(Context context, Arguments args) {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.hasMaster() ? (this.getMaster() != null ? (((TileFissionController)this.getMaster()).cells == 0 ? ((TileFissionController)this.getMaster()).baseProcessTime : ((TileFissionController)this.getMaster()).baseProcessTime / (double)((TileFissionController)this.getMaster()).cells) : 0.0) : 0.0;
        return objectArray;
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorProcessPower(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).processPower : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorProcessHeat(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).heatChange : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorCoolingRate(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).cooling : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfCells(Context context, Arguments args) {
        return new Object[]{this.hasMaster() ? ((TileFissionController)this.getMaster()).cells : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getReactorLayout(Context context, Arguments args) {
        return this.hasMaster() ? ((TileFissionController)this.getMaster()).getOCReactorLayout() : new Object[]{};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] activate(Context context, Arguments args) {
        if (this.hasMaster()) {
            ((TileFissionController)this.getMaster()).computerActivated = true;
        }
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] deactivate(Context context, Arguments args) {
        if (this.hasMaster()) {
            ((TileFissionController)this.getMaster()).computerActivated = false;
        }
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] forceUpdate(Context context, Arguments args) {
        if (this.hasMaster()) {
            ((TileFissionController)this.getMaster()).refreshMultiblock(true);
        }
        return new Object[0];
    }
}

