/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.sync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.sync.ISyncHandler;

public class SyncHandlerPrimitive {

    public static class SyncHandlerIntArray
    implements ISyncHandler<int[]> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, int[] value) {
            tag.func_74783_a(key, value);
            return tag;
        }

        @Override
        public int[] load(NBTTagCompound tag, String key) {
            return tag.func_74759_k(key);
        }

        @Override
        public ByteBuf save(ByteBuf buf, int[] value) {
            buf.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                buf.writeInt(value[i]);
            }
            return buf;
        }

        @Override
        public int[] load(ByteBuf buf) {
            int[] value = new int[buf.readInt()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = buf.readInt();
            }
            return value;
        }
    }

    public static class SyncHandlerByteArray
    implements ISyncHandler<byte[]> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, byte[] value) {
            tag.func_74773_a(key, value);
            return tag;
        }

        @Override
        public byte[] load(NBTTagCompound tag, String key) {
            return tag.func_74770_j(key);
        }

        @Override
        public ByteBuf save(ByteBuf buf, byte[] value) {
            buf.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                buf.writeByte((int)value[i]);
            }
            return buf;
        }

        @Override
        public byte[] load(ByteBuf buf) {
            byte[] value = new byte[buf.readInt()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = buf.readByte();
            }
            return value;
        }
    }

    public static class SyncHandlerDouble
    implements ISyncHandler<Double> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, Double value) {
            tag.func_74780_a(key, value.doubleValue());
            return tag;
        }

        @Override
        public Double load(NBTTagCompound tag, String key) {
            return tag.func_74769_h(key);
        }

        @Override
        public ByteBuf save(ByteBuf buf, Double value) {
            return buf.writeDouble(value.doubleValue());
        }

        @Override
        public Double load(ByteBuf buf) {
            return buf.readDouble();
        }
    }

    public static class SyncHandlerFloat
    implements ISyncHandler<Float> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, Float value) {
            tag.func_74776_a(key, value.floatValue());
            return tag;
        }

        @Override
        public Float load(NBTTagCompound tag, String key) {
            return Float.valueOf(tag.func_74760_g(key));
        }

        @Override
        public ByteBuf save(ByteBuf buf, Float value) {
            return buf.writeFloat(value.floatValue());
        }

        @Override
        public Float load(ByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }
    }

    public static class SyncHandlerLong
    implements ISyncHandler<Long> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, Long value) {
            tag.func_74772_a(key, value.longValue());
            return tag;
        }

        @Override
        public Long load(NBTTagCompound tag, String key) {
            return tag.func_74763_f(key);
        }

        @Override
        public ByteBuf save(ByteBuf buf, Long value) {
            return buf.writeLong(value.longValue());
        }

        @Override
        public Long load(ByteBuf buf) {
            return buf.readLong();
        }
    }

    public static class SyncHandlerInteger
    implements ISyncHandler<Integer> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, Integer value) {
            tag.func_74768_a(key, value.intValue());
            return tag;
        }

        @Override
        public Integer load(NBTTagCompound tag, String key) {
            return tag.func_74762_e(key);
        }

        @Override
        public ByteBuf save(ByteBuf buf, Integer value) {
            return buf.writeInt(value.intValue());
        }

        @Override
        public Integer load(ByteBuf buf) {
            return buf.readInt();
        }
    }

    public static class SyncHandlerShort
    implements ISyncHandler<Short> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, Short value) {
            tag.func_74777_a(key, value.shortValue());
            return tag;
        }

        @Override
        public Short load(NBTTagCompound tag, String key) {
            return tag.func_74765_d(key);
        }

        @Override
        public ByteBuf save(ByteBuf buf, Short value) {
            return buf.writeShort((int)value.shortValue());
        }

        @Override
        public Short load(ByteBuf buf) {
            return buf.readShort();
        }
    }

    public static class SyncHandlerByte
    implements ISyncHandler<Byte> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, Byte value) {
            tag.func_74774_a(key, value.byteValue());
            return tag;
        }

        @Override
        public Byte load(NBTTagCompound tag, String key) {
            return tag.func_74771_c(key);
        }

        @Override
        public ByteBuf save(ByteBuf buf, Byte value) {
            return buf.writeByte((int)value.byteValue());
        }

        @Override
        public Byte load(ByteBuf buf) {
            return buf.readByte();
        }
    }

    public static class SyncHandlerBoolean
    implements ISyncHandler<Boolean> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, Boolean value) {
            tag.func_74757_a(key, value.booleanValue());
            return tag;
        }

        @Override
        public Boolean load(NBTTagCompound tag, String key) {
            return tag.func_74767_n(key);
        }

        @Override
        public ByteBuf save(ByteBuf buf, Boolean value) {
            return buf.writeBoolean(value.booleanValue());
        }

        @Override
        public Boolean load(ByteBuf buf) {
            return buf.readBoolean();
        }
    }
}

