/*
 * Decompiled with CFR 0.152.
 */
package net.rom.gctweaks.base;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.rom.gctweaks.base.Feature;

public abstract class Module {
    private List<Feature> features = new ArrayList<Feature>();
    private String name;
    private Configuration config;
    private boolean setConfig;

    public Module(String name) {
        this.setConfig = true;
        this.name = name;
        this.addFeatures();
    }

    public Module() {
        this.setConfig = false;
        this.addFeatures();
    }

    public abstract void addFeatures();

    public void preInit() {
        this.features.stream().filter(Feature::usesEvents).forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).register(arg_0));
        this.features.forEach(Feature::preInit);
    }

    public void proxyPreInit() {
        this.features.stream().filter(Feature::sidedProxy).forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).register(arg_0));
        this.features.forEach(Feature::proxyPreInit);
    }

    public void setupConfig(FMLPreInitializationEvent event) {
        if (this.setConfig) {
            File file = new File(event.getModConfigurationDirectory().toString() + "/GalacticTweaks/" + this.name + ".cfg");
            this.config = new Configuration(file, "3");
            this.config.load();
        }
    }

    public void init() {
        this.features.forEach(Feature::init);
    }

    public void postInit() {
        this.features.forEach(Feature::postInit);
    }

    public void proxyInit() {
        this.features.forEach(Feature::proxyInit);
    }

    public void proxyPostInit() {
        this.features.forEach(Feature::proxyPostInit);
    }

    public void serverStartingEvent(FMLServerStartingEvent event) {
        this.features.forEach(feature -> feature.ServerStartingEvent(event));
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void syncConfig() {
        this.features.forEach(feature -> {
            feature.syncConfig(this.config, feature.category());
            this.config.addCustomCategoryComment(feature.category()[0], feature.comment());
            if (this.config.hasChanged()) {
                this.config.save();
            }
        });
    }

    protected void registerFeature(Feature feature) {
        this.features.add(feature);
    }

    public void registerPacket(SimpleNetworkWrapper network) {
        this.features.forEach(feature -> feature.registerPacket(network));
    }
}

