/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.client.gui;

import com.github.terminatornl.laggoggles.client.ClientProxy;
import com.github.terminatornl.laggoggles.client.gui.GuiScanResultsWorld;
import com.github.terminatornl.laggoggles.packet.CPacketRequestEntityTeleport;
import com.github.terminatornl.laggoggles.packet.CPacketRequestTileEntityTeleport;
import com.github.terminatornl.laggoggles.packet.ObjectData;
import com.github.terminatornl.laggoggles.profiler.ProfileResult;
import com.github.terminatornl.laggoggles.profiler.ScanType;
import com.github.terminatornl.laggoggles.util.Calculations;
import com.github.terminatornl.laggoggles.util.Graphical;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiSingleEntities
extends GuiScrollingList {
    private ArrayList<GuiScanResultsWorld.LagSource> LAGSOURCES;
    private int selected;
    private final FontRenderer FONTRENDERER;
    private static final int slotHeight = 12;
    private int COLUMN_WIDTH_NANOS;
    private int COLUMN_WIDTH_PERCENTAGES;
    private ProfileResult result;

    public GuiSingleEntities(Minecraft client, int width, int height, int top, int bottom, int left, int screenWidth, int screenHeight, ProfileResult result) {
        block14: {
            ScanType type;
            block13: {
                super(client, width, height, top, bottom, left, 12, screenWidth, screenHeight);
                this.LAGSOURCES = new ArrayList();
                this.selected = -1;
                this.COLUMN_WIDTH_NANOS = 0;
                this.COLUMN_WIDTH_PERCENTAGES = 0;
                this.FONTRENDERER = client.field_71466_p;
                this.result = result;
                type = result.getType();
                if (type == ScanType.WORLD) {
                    for (GuiScanResultsWorld.LagSource src : result.getLagSources()) {
                        switch (src.data.type) {
                            case BLOCK: 
                            case ENTITY: 
                            case TILE_ENTITY: {
                                this.LAGSOURCES.add(src);
                            }
                        }
                    }
                } else if (type == ScanType.FPS) {
                    for (GuiScanResultsWorld.LagSource src : result.getLagSources()) {
                        switch (src.data.type) {
                            case GUI_BLOCK: 
                            case GUI_ENTITY: {
                                this.LAGSOURCES.add(src);
                            }
                        }
                    }
                }
                Collections.sort(this.LAGSOURCES);
                if (type != ScanType.WORLD) break block13;
                for (GuiScanResultsWorld.LagSource src : this.LAGSOURCES) {
                    this.COLUMN_WIDTH_NANOS = Math.max(this.COLUMN_WIDTH_NANOS, this.FONTRENDERER.func_78256_a(Calculations.muPerTickString(src.nanos, result)));
                    this.COLUMN_WIDTH_PERCENTAGES = Math.max(this.COLUMN_WIDTH_PERCENTAGES, this.FONTRENDERER.func_78256_a(Calculations.tickPercent(src.nanos, result)));
                }
                break block14;
            }
            if (type != ScanType.FPS) break block14;
            for (GuiScanResultsWorld.LagSource src : this.LAGSOURCES) {
                this.COLUMN_WIDTH_NANOS = Math.max(this.COLUMN_WIDTH_NANOS, this.FONTRENDERER.func_78256_a(Calculations.NFStringSimple(src.nanos, result.getTotalFrames())));
                this.COLUMN_WIDTH_PERCENTAGES = Math.max(this.COLUMN_WIDTH_PERCENTAGES, this.FONTRENDERER.func_78256_a(Calculations.nfPercent(src.nanos, result)));
            }
        }
    }

    protected int getSize() {
        return this.LAGSOURCES.size();
    }

    protected void elementClicked(int slot, boolean doubleClick) {
        this.selected = slot;
        if (doubleClick) {
            switch (this.LAGSOURCES.get((int)slot).data.type) {
                case BLOCK: 
                case TILE_ENTITY: 
                case GUI_BLOCK: {
                    ClientProxy.NETWORK_WRAPPER.sendToServer((IMessage)new CPacketRequestTileEntityTeleport(this.LAGSOURCES.get((int)slot).data));
                    Minecraft.func_71410_x().func_147108_a(null);
                    break;
                }
                case ENTITY: 
                case GUI_ENTITY: {
                    ClientProxy.NETWORK_WRAPPER.sendToServer((IMessage)new CPacketRequestEntityTeleport((UUID)this.LAGSOURCES.get((int)slot).data.getValue(ObjectData.Entry.ENTITY_UUID)));
                    Minecraft.func_71410_x().func_147108_a(null);
                }
            }
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    protected boolean isSelected(int index) {
        return this.selected == index;
    }

    protected void drawBackground() {
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput(this.left, this.top);
    }

    protected void drawSlot(int slot, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        String className;
        String name;
        if (slot == -1) {
            return;
        }
        GuiScanResultsWorld.LagSource source = this.LAGSOURCES.get(slot);
        double heat = this.result.getType() == ScanType.WORLD ? Calculations.heat(source.nanos, this.result) : Calculations.heatNF(source.nanos, this.result);
        double[] RGB = Graphical.heatToColor(heat);
        int color = Graphical.RGBtoInt(RGB);
        int offSet = 5 + this.COLUMN_WIDTH_NANOS;
        if (this.result.getType() == ScanType.WORLD) {
            this.drawStringToLeftOf(Calculations.muPerTickString(source.nanos, this.result), offSet, slotTop, color);
        } else if (this.result.getType() == ScanType.FPS) {
            this.drawStringToLeftOf(Calculations.NFStringSimple(source.nanos, this.result.getTotalFrames()), offSet, slotTop, color);
            offSet = offSet + 5 + this.COLUMN_WIDTH_PERCENTAGES;
            this.drawStringToLeftOf(Calculations.nfPercent(source.nanos, this.result), offSet, slotTop, color);
        }
        offSet += 5;
        switch (source.data.type) {
            case ENTITY: 
            case GUI_ENTITY: {
                name = (String)source.data.getValue(ObjectData.Entry.ENTITY_NAME);
                className = (String)source.data.getValue(ObjectData.Entry.ENTITY_CLASS_NAME);
                break;
            }
            case BLOCK: 
            case TILE_ENTITY: 
            case GUI_BLOCK: {
                name = (String)source.data.getValue(ObjectData.Entry.BLOCK_NAME);
                className = (String)source.data.getValue(ObjectData.Entry.BLOCK_CLASS_NAME);
                break;
            }
            default: {
                name = "Error! Please submit an issue at github";
                className = source.data.type.toString();
            }
        }
        this.drawString(name, offSet, slotTop, color);
        offSet = offSet + this.FONTRENDERER.func_78256_a(name) + 5;
        this.drawString(className, offSet, slotTop, 0x4C4C4C);
    }

    private void drawString(String text, int x, int y, int color) {
        this.FONTRENDERER.func_175063_a(text, (float)x, (float)y, color);
    }

    private void drawStringToLeftOf(String text, int right, int y, int color) {
        this.FONTRENDERER.func_175063_a(text, (float)(right - this.FONTRENDERER.func_78256_a(text)), (float)y, color);
    }
}

