/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.ZenParsedFile;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.compiler.ClassNameGenerator;
import stanhebben.zenscript.compiler.EnvironmentClass;
import stanhebben.zenscript.compiler.EnvironmentGlobal;
import stanhebben.zenscript.compiler.EnvironmentMethod;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.ZenClassWriter;
import stanhebben.zenscript.definitions.ParsedFunction;
import stanhebben.zenscript.definitions.ParsedFunctionArgument;
import stanhebben.zenscript.definitions.ParsedGlobalValue;
import stanhebben.zenscript.definitions.zenclasses.ParsedZenClass;
import stanhebben.zenscript.expression.partial.PartialScriptReference;
import stanhebben.zenscript.statements.Statement;
import stanhebben.zenscript.statements.StatementReturn;
import stanhebben.zenscript.symbols.SymbolArgument;
import stanhebben.zenscript.symbols.SymbolGlobalValue;
import stanhebben.zenscript.symbols.SymbolScriptReference;
import stanhebben.zenscript.symbols.SymbolZenClass;
import stanhebben.zenscript.symbols.SymbolZenStaticMethod;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.StringUtil;
import stanhebben.zenscript.util.ZenTypeUtil;

public class ZenModule {
    public static final Map<String, byte[]> classes = new HashMap<String, byte[]>();
    public static final Map<String, Class> loadedClasses = new HashMap<String, Class>();
    private final MyClassLoader classLoader;

    public ZenModule(Map<String, byte[]> clazzes, ClassLoader baseClassLoader) {
        classes.putAll(clazzes);
        this.classLoader = new MyClassLoader(baseClassLoader);
    }

    public static void compileScripts(String mainFileName, List<ZenParsedFile> scripts, IEnvironmentGlobal environmentGlobal, boolean debug) {
        ZenClassWriter clsMain = new ZenClassWriter(2);
        clsMain.visitSource(mainFileName, null);
        clsMain.visit(52, 1, "__ZenMain__", null, ZenTypeUtil.internal(Object.class), new String[]{ZenTypeUtil.internal(Runnable.class)});
        MethodOutput mainRun = new MethodOutput((ClassVisitor)clsMain, 1, "run", "()V", null, null);
        mainRun.start();
        for (ZenParsedFile script : scripts) {
            ParsedFunction fn;
            ZenClassWriter clsScript = new ZenClassWriter(2);
            clsScript.visitSource(script.getFileName(), null);
            EnvironmentClass environmentScript = new EnvironmentClass((ClassVisitor)clsScript, script.getEnvironment());
            clsScript.visit(52, 1, script.getClassName().replace('.', '/'), null, ZenTypeUtil.internal(Object.class), new String[]{ZenTypeUtil.internal(Runnable.class)});
            if (!script.getClasses().isEmpty()) {
                for (Map.Entry<String, ParsedZenClass> entry : script.getClasses().entrySet()) {
                    environmentScript.putValue(entry.getKey(), new SymbolZenClass(entry.getValue().type), entry.getValue().position);
                }
            }
            if (!script.getGlobals().isEmpty()) {
                MethodOutput clinit = new MethodOutput((ClassVisitor)clsScript, 8, "<clinit>", "()V", null, null);
                EnvironmentMethod clinitEnvironment = new EnvironmentMethod(clinit, environmentScript);
                clinit.start();
                for (Map.Entry<String, ParsedGlobalValue> entry : script.getGlobals().entrySet()) {
                    ParsedGlobalValue value = entry.getValue();
                    if (value.isGlobal()) {
                        environmentGlobal.putValue(entry.getKey(), new SymbolGlobalValue(value, clinitEnvironment), value.getPosition());
                        continue;
                    }
                    environmentScript.putValue(entry.getKey(), new SymbolGlobalValue(value, clinitEnvironment), value.getPosition());
                }
                clinit.ret();
                clinit.end();
            }
            if (!(script.getFunctions().isEmpty() && script.getGlobals().isEmpty() && script.getClasses().isEmpty())) {
                Object fileName = script.getFileName();
                if (((String)fileName).startsWith("scripts.zip" + File.separator)) {
                    fileName = ((String)fileName).substring(12);
                }
                String[] splitName = ((String)fileName).replaceAll("\\.zip", "").split("\\.|\\" + File.separator);
                PartialScriptReference reference = SymbolScriptReference.getOrCreateReference(environmentGlobal);
                if (splitName.length != 0) {
                    reference.addScriptOrDirectory(environmentScript, Arrays.copyOfRange(splitName, 0, splitName.length - 1));
                }
            }
            for (Map.Entry<String, ParsedFunction> function : script.getFunctions().entrySet()) {
                fn = (ParsedFunction)function.getValue();
                environmentScript.putValue((String)function.getKey(), new SymbolZenStaticMethod(script.getClassName(), fn.getName(), fn.getSignature(), fn.getArgumentTypes(), fn.getReturnType()), fn.getPosition());
            }
            for (Map.Entry<String, ParsedFunction> function : script.getFunctions().entrySet()) {
                Statement[] statements;
                fn = function.getValue();
                String signature = fn.getSignature();
                MethodOutput methodOutput = new MethodOutput((ClassVisitor)clsScript, 9, function.getKey(), signature, null, null);
                EnvironmentMethod methodEnvironment = new EnvironmentMethod(methodOutput, environmentScript);
                List<ParsedFunctionArgument> arguments = function.getValue().getArguments();
                int j = 0;
                for (int i = 0; i < arguments.size(); ++i) {
                    ParsedFunctionArgument argument = arguments.get(i);
                    methodEnvironment.putValue(argument.getName(), new SymbolArgument(i + j, argument.getType()), fn.getPosition());
                    if (!argument.getType().isLarge()) continue;
                    ++j;
                }
                methodOutput.start();
                for (Statement statement : statements = fn.getStatements()) {
                    statement.compile(methodEnvironment);
                }
                if (function.getValue().getReturnType() != ZenType.VOID) {
                    if (statements.length > 0 && statements[statements.length - 1] instanceof StatementReturn) {
                        if (((StatementReturn)statements[statements.length - 1]).getExpression() != null) {
                            fn.getReturnType().defaultValue(fn.getPosition()).compile(true, methodEnvironment);
                            methodOutput.returnType(fn.getReturnType().toASMType());
                        }
                    } else {
                        fn.getReturnType().defaultValue(fn.getPosition()).compile(true, methodEnvironment);
                        methodOutput.returnType(fn.getReturnType().toASMType());
                    }
                } else if (statements.length == 0 || !(statements[statements.length - 1] instanceof StatementReturn)) {
                    methodOutput.ret();
                }
                methodOutput.end();
            }
            if (script.getStatements().size() > 0) {
                MethodOutput scriptOutput = new MethodOutput((ClassVisitor)clsScript, 9, "__script__", "()V", null, null);
                EnvironmentMethod functionMethod = new EnvironmentMethod(scriptOutput, environmentScript);
                scriptOutput.start();
                for (Statement statement : script.getStatements()) {
                    statement.compile(functionMethod);
                }
                scriptOutput.ret();
                scriptOutput.end();
                mainRun.invokeStatic(script.getClassName().replace('.', '/'), "__script__", "()V");
            }
            clsScript.visitEnd();
            environmentGlobal.putClass(script.getClassName(), clsScript.toByteArray());
        }
        mainRun.ret();
        mainRun.end();
        clsMain.visitEnd();
        MethodVisitor constructor = clsMain.visitMethod(1, "<init>", "()V", null, null);
        constructor.visitCode();
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        constructor.visitInsn(177);
        constructor.visitMaxs(0, 0);
        constructor.visitEnd();
        if (debug) {
            try {
                File outputDir = new File("generated");
                outputDir.mkdir();
                for (String className : environmentGlobal.getClassNames()) {
                    File outputFile = new File(outputDir, className.replace('.', '/') + ".class");
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    FileOutputStream output = new FileOutputStream(outputFile);
                    output.write(environmentGlobal.getClass(className));
                    output.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        environmentGlobal.putClass("__ZenMain__", clsMain.toByteArray());
    }

    public static ZenModule compileScriptFile(File single, IZenCompileEnvironment environment, ClassLoader baseClassLoader) throws IOException {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        ClassNameGenerator nameGen = new ClassNameGenerator();
        EnvironmentGlobal environmentGlobal = new EnvironmentGlobal(environment, classes, nameGen);
        String filename = single.getName();
        String className = ZenModule.extractClassName(filename);
        FileInputStream input = new FileInputStream(single);
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(input));
        ZenTokener parser = new ZenTokener(reader, environment, filename, false);
        ZenParsedFile file = new ZenParsedFile(filename, className, parser, environmentGlobal);
        ((Reader)reader).close();
        ArrayList<ZenParsedFile> files = new ArrayList<ZenParsedFile>();
        files.add(file);
        ZenModule.compileScripts(filename, files, environmentGlobal, false);
        ZenModule.generateDebug(classes);
        return new ZenModule(classes, baseClassLoader);
    }

    public static ZenModule compileScriptString(String script, String name, IZenCompileEnvironment environment, ClassLoader baseClassLoader) throws IOException {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        ClassNameGenerator nameGen = new ClassNameGenerator();
        EnvironmentGlobal environmentGlobal = new EnvironmentGlobal(environment, classes, nameGen);
        String className = ZenModule.extractClassName(name);
        StringReader reader = new StringReader(script);
        ZenTokener parser = new ZenTokener(reader, environment, name, false);
        ZenParsedFile file = new ZenParsedFile(name, className, parser, environmentGlobal);
        reader.close();
        ArrayList<ZenParsedFile> files = new ArrayList<ZenParsedFile>();
        files.add(file);
        ZenModule.compileScripts(name, files, environmentGlobal, false);
        ZenModule.generateDebug(classes);
        return new ZenModule(classes, baseClassLoader);
    }

    public static ZenModule compileZip(File file, String subdir, IZenCompileEnvironment environment, ClassLoader baseClassLoader) throws IOException {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        ClassNameGenerator nameGen = new ClassNameGenerator();
        EnvironmentGlobal environmentGlobal = new EnvironmentGlobal(environment, classes, nameGen);
        ArrayList<ZenParsedFile> files = new ArrayList<ZenParsedFile>();
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(subdir) || entry.getName().equals(subdir)) continue;
            String filename = entry.getName().substring(subdir.length());
            String className = ZenModule.extractClassName(filename);
            InputStreamReader reader = new InputStreamReader(new BufferedInputStream(zipFile.getInputStream(entry)));
            ZenTokener parser = new ZenTokener(reader, environment, filename, false);
            ZenParsedFile pfile = new ZenParsedFile(filename, className, parser, environmentGlobal);
            files.add(pfile);
            ((Reader)reader).close();
        }
        String filename = file.getName();
        ZenModule.compileScripts(filename, files, environmentGlobal, true);
        return new ZenModule(classes, baseClassLoader);
    }

    private static void generateDebug(Map<String, byte[]> classes) throws IOException {
        File outputDir = new File("generated");
        outputDir.mkdir();
        for (Map.Entry<String, byte[]> entry : classes.entrySet()) {
            File outputFile = new File(outputDir, entry.getKey().replace('.', '/') + ".class");
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            FileOutputStream output = new FileOutputStream(outputFile);
            output.write(entry.getValue());
            output.close();
        }
    }

    public static String extractClassName(String filename) {
        String name;
        String dir;
        int lastDot;
        if ((filename = filename.replace('\\', '/')).startsWith("/")) {
            filename = filename.substring(1);
        }
        if ((lastDot = filename.lastIndexOf(46)) > 0) {
            filename = filename.substring(0, lastDot);
        }
        filename = filename.replace(".", "_");
        int lastSlash = (filename = filename.replace(" ", "_")).lastIndexOf(47);
        if (lastSlash > 0) {
            dir = filename.substring(0, lastSlash);
            name = filename.substring(lastSlash + 1);
        } else {
            name = filename;
            dir = "";
        }
        return (dir.length() > 0 ? dir.replace('/', '\\') + "\\" : "") + StringUtil.capitalize(name);
    }

    public Runnable getMain() {
        try {
            return (Runnable)this.classLoader.loadClass("__ZenMain__").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    private class MyClassLoader
    extends ClassLoader {
        private MyClassLoader(ClassLoader baseClassLoader) {
            super(baseClassLoader);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            if (loadedClasses.containsKey(name)) {
                return loadedClasses.get(name);
            }
            if (classes.containsKey(name)) {
                byte[] bytes = classes.get(name);
                if ("__ZenMain__".equals(name)) {
                    return this.defineClass(name, bytes, 0, bytes.length);
                }
                loadedClasses.put(name, this.defineClass(name, bytes, 0, bytes.length));
                return loadedClasses.get(name);
            }
            return super.findClass(name);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (loadedClasses.containsKey(name)) {
                return loadedClasses.get(name);
            }
            if (classes.containsKey(name)) {
                byte[] bytes = classes.get(name);
                if ("__ZenMain__".equals(name)) {
                    return this.defineClass(name, bytes, 0, bytes.length);
                }
                loadedClasses.put(name, this.defineClass(name, bytes, 0, bytes.length));
                return loadedClasses.get(name);
            }
            return super.loadClass(name);
        }
    }
}

