/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tickcentral.api;

import com.github.terminatornl.tickcentral.TickCentral;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class ClassSniffer {
    private static final HashMap<String, HashSet<String>> KNOWN_IMPLEMENTORS = new HashMap();
    private static final Set<String> classLoaderExceptions;
    private static final Set<String> transformerExceptions;

    private static boolean isProtected(String target) {
        target = target.replace("/", ".");
        for (String exceptions : classLoaderExceptions) {
            if (!target.startsWith(exceptions)) continue;
            return true;
        }
        for (String exceptions : transformerExceptions) {
            if (!target.startsWith(exceptions)) continue;
            return true;
        }
        return false;
    }

    private static void addKnownImplementor(String className, String obfuscated) {
        HashSet implementors = KNOWN_IMPLEMENTORS.computeIfAbsent(obfuscated, k -> new HashSet());
        implementors.add(className);
    }

    private static boolean isKnownImplementor(String className, String obfuscated) {
        HashSet<String> implementors = KNOWN_IMPLEMENTORS.get(obfuscated);
        if (implementors == null) {
            return false;
        }
        return implementors.contains(className);
    }

    public static boolean isInstanceOf(ClassReader reader, String obfuscated) throws IOException {
        return ClassSniffer.isInstanceOf(reader, obfuscated, true);
    }

    public static boolean isInstanceOf(ClassReader reader, String obfuscated, boolean disallowMixinSupers) throws IOException {
        String className = FMLDeobfuscatingRemapper.INSTANCE.unmap(reader.getClassName());
        if (ClassSniffer.isKnownImplementor(className, obfuscated)) {
            return true;
        }
        if (className.equals(obfuscated)) {
            ClassSniffer.addKnownImplementor(className, obfuscated);
            return true;
        }
        String superName = reader.getSuperName();
        if (superName.equals(obfuscated)) {
            ClassSniffer.addKnownImplementor(className, obfuscated);
            return true;
        }
        for (String string : reader.getInterfaces()) {
            if (!string.equals(obfuscated)) continue;
            ClassSniffer.addKnownImplementor(className, obfuscated);
            return true;
        }
        if (!ClassSniffer.isProtected(superName)) {
            byte[] superClass = TickCentral.LOADER.getClassLoader().getClassBytes(FMLDeobfuscatingRemapper.INSTANCE.unmap(superName));
            if (superClass == null) {
                TickCentral.LOGGER.warn("Unable to get superclass as resource: " + superName + " (" + FMLDeobfuscatingRemapper.INSTANCE.map(superName) + ") Do you have a broken installation? It is referenced in " + className + " (" + FMLDeobfuscatingRemapper.INSTANCE.map(className) + ")");
            } else {
                ClassReader superReader = new ClassReader(superClass);
                if (disallowMixinSupers) {
                    ClassNode superClassNode = new ClassNode();
                    superReader.accept((ClassVisitor)superClassNode, 0);
                    if (superClassNode.invisibleAnnotations != null) {
                        for (AnnotationNode annotation : superClassNode.invisibleAnnotations) {
                            if (!annotation.desc.equals("Lorg/spongepowered/asm/mixin/Mixin;")) continue;
                            return false;
                        }
                    }
                }
                if (ClassSniffer.isInstanceOf(superReader, obfuscated, disallowMixinSupers)) {
                    return true;
                }
            }
        }
        for (String string : reader.getInterfaces()) {
            byte[] ifaceData;
            if (ClassSniffer.isProtected(string) || (ifaceData = TickCentral.LOADER.getClassLoader().getClassBytes(FMLDeobfuscatingRemapper.INSTANCE.unmap(string))) == null || !ClassSniffer.isInstanceOf(new ClassReader(ifaceData), obfuscated, disallowMixinSupers)) continue;
            return true;
        }
        return false;
    }

    public static <R> R performOnSource(String source, Function<ClassReader, R> callable) throws IOException, ClassNotFoundException {
        byte[] data = TickCentral.LOADER.getClassLoader().getClassBytes(FMLDeobfuscatingRemapper.INSTANCE.unmap(source));
        if (data == null) {
            throw new ClassNotFoundException("Unable to find class: " + source + " (" + FMLDeobfuscatingRemapper.INSTANCE.unmap(source) + ")");
        }
        return callable.apply(new ClassReader(data));
    }

    static {
        try {
            Field classExceptions = LaunchClassLoader.class.getDeclaredField("classLoaderExceptions");
            classExceptions.setAccessible(true);
            classLoaderExceptions = (Set)classExceptions.get(ClassSniffer.class.getClassLoader());
            Field transformExceptions = LaunchClassLoader.class.getDeclaredField("transformerExceptions");
            transformExceptions.setAccessible(true);
            transformerExceptions = (Set)transformExceptions.get(ClassSniffer.class.getClassLoader());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

