/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.util;

import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;

public final class CertificateHelper {
    private static final String HEXES = "0123456789abcdef";

    private CertificateHelper() {
    }

    public static List<String> getFingerprints(Certificate[] certificates) {
        int length = 0;
        if (certificates != null) {
            length = certificates.length;
        }
        ArrayList<String> fingerprints = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            fingerprints.add(CertificateHelper.getFingerprint(certificates[i]));
        }
        return fingerprints;
    }

    public static String getFingerprint(Certificate certificate) {
        if (certificate == null) {
            return "NO VALID CERTIFICATE FOUND";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] encoded = certificate.getEncoded();
            digest.update(encoded);
            byte[] checksum = digest.digest();
            return CertificateHelper.hexify(checksum);
        }
        catch (Exception ex) {
            return "CERTIFICATE FINGERPRINT EXCEPTION";
        }
    }

    private static String hexify(byte[] checksum) {
        StringBuilder hex = new StringBuilder(2 * checksum.length);
        for (byte b : checksum) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }
}

