/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import javax.annotation.Nullable;

public interface Property<K, V>
extends Comparable<Property<?, ?>> {
    public K getKey();

    @Nullable
    public V getValue();

    public Operator getOperator();

    public boolean matches(@Nullable Property<?, ?> var1);

    public static enum Operator {
        DELEGATE{

            @Override
            protected boolean apply(Property<?, ?> operand1, Property<?, ?> operand2) {
                return operand2.getOperator() != DELEGATE && operand2.getOperator().compare(operand1, operand2);
            }
        }
        ,
        EQUAL{

            @Override
            protected boolean apply(Property<?, ?> operand1, Property<?, ?> operand2) {
                return operand2.equals(operand1);
            }
        }
        ,
        NOTEQUAL{

            @Override
            protected boolean apply(Property<?, ?> operand1, Property<?, ?> operand2) {
                return !operand2.equals(operand1);
            }
        }
        ,
        GREATER{

            @Override
            protected boolean apply(Property<?, ?> operand1, Property<?, ?> operand2) {
                int result = operand2.compareTo(operand1);
                return result > 0;
            }
        }
        ,
        GEQUAL{

            @Override
            protected boolean apply(Property<?, ?> operand1, Property<?, ?> operand2) {
                int result = operand2.compareTo(operand1);
                return result >= 0;
            }
        }
        ,
        LESS{

            @Override
            protected boolean apply(Property<?, ?> operand1, Property<?, ?> operand2) {
                int result = operand2.compareTo(operand1);
                return result < 0;
            }
        }
        ,
        LEQUAL{

            @Override
            protected boolean apply(Property<?, ?> operand1, Property<?, ?> operand2) {
                int result = operand2.compareTo(operand1);
                return result <= 0;
            }
        };


        public final boolean compare(@Nullable Property<?, ?> operand1, @Nullable Property<?, ?> operand2) {
            if (this == EQUAL && operand1 == operand2) {
                return true;
            }
            if (operand1 == null || operand2 == null) {
                return false;
            }
            return this.apply(operand1, operand2);
        }

        protected abstract boolean apply(Property<?, ?> var1, Property<?, ?> var2);

        public static Operator defaultOperator() {
            return DELEGATE;
        }
    }
}

