/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class Tuple<K, V> {
    private final K first;
    private final V second;

    public static <K, V> Tuple<K, V> of(K first, V second) {
        return new Tuple<K, V>(first, second);
    }

    public Tuple(K first, V second) {
        this.first = Preconditions.checkNotNull(first);
        this.second = Preconditions.checkNotNull(second);
    }

    public K getFirst() {
        return this.first;
    }

    public V getSecond() {
        return this.second;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("first", this.first).add("second", this.second).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.first, this.second});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return Objects.equal(this.first, other.first) && Objects.equal(this.second, other.second);
    }
}

