/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.category;

import java.io.IOException;
import net.minecraft.launchwrapper.Launch;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.common.config.category.AsyncLightingCategory;
import org.spongepowered.common.config.category.ConfigCategory;
import org.spongepowered.common.config.category.EigenRedstoneCategory;
import org.spongepowered.common.config.category.StructureSaveCategory;

@ConfigSerializable
public class OptimizationCategory
extends ConfigCategory {
    @Setting(value="drops-pre-merge", comment="If 'true', block item drops are pre-processed to avoid \nhaving to spawn extra entities that will be merged post spawning. \nUsually, Sponge is smart enough to determine when to attempt an item pre-merge \nand when not to, however, in certain cases, some mods rely on items not being \npre-merged and actually spawned, in which case, the items will flow right through \nwithout being merged.")
    private boolean preItemDropMerge = false;
    @Setting(value="cache-tameable-owners", comment="Caches tameable entities owners to avoid constant lookups against data watchers. If mods \ncause issues, disable this.")
    private boolean cacheTameableOwners = true;
    @Setting(value="structure-saving", comment="Handles structures that are saved to disk. Certain structures can take up large amounts \nof disk space for very large maps and the data for these structures is only needed while the \nworld around them is generating. Disabling saving of these structures can save disk space and \ntime during saves if your world is already fully generated. \nWarning: disabling structure saving will break the vanilla locate command.")
    private StructureSaveCategory structureSaveCategory = new StructureSaveCategory();
    @Setting(value="async-lighting", comment="Runs lighting updates asynchronously.")
    private AsyncLightingCategory asyncLightingCategory = new AsyncLightingCategory();
    @Setting(value="eigen-redstone", comment="Uses theosib's redstone algorithms to completely overhaul the way redstone works.")
    private EigenRedstoneCategory eigenRedstonCategory = new EigenRedstoneCategory();
    @Setting(value="panda-redstone", comment="If 'true', uses Panda4494's redstone implementation which improves performance. \nSee https://bugs.mojang.com/browse/MC-11193 for more information. \nNote: This optimization has a few issues which are explained in the bug report. \nWe strongly recommend using eigen redstone over this implementation as this will\nbe removed in a future release.")
    private boolean pandaRedstone = false;
    @Setting(value="enchantment-helper-leak-fix", comment="If 'true', provides a fix for possible leaks through\nMinecraft's enchantment helper code that can leak\nentity and world references without much interaction\nForge native (so when running SpongeForge implementation)\nhas a similar patch, but Sponge's patch works a little harder\nat it, but Vanilla (SpongeVanilla implementation) does NOT\nhave any of the patch, leading to the recommendation that this\npatch is enabled \"for sure\" when using SpongeVanilla implementation.\nSee https://bugs.mojang.com/browse/MC-128547 for more information.\n")
    private boolean enchantmentLeak = true;
    @Setting(value="faster-thread-checks", comment="If 'true', allows for Sponge to make better assumptinos on single threaded\noperations with relation to various checks for server threaded operations.\nThis is default to true due to Sponge being able to precisely inject when\nthe server thread is available. This should make an already fast operation\nmuch faster for better thread checks to ensure stability of sponge's systems.")
    private boolean fasterThreadChecks = true;
    @Setting(value="map-optimization", comment="If 'true', re-writes the incredibly inefficient Vanilla Map code.\nThis yields enormous performance enhancements when using many maps, but has a tiny chance of breaking mods that invasively modify Vanilla.It is strongly reccomended to keep this on, unless explicitly advised otherwise by a Sponge developer")
    private boolean mapOptimization = true;
    @Setting(value="optimize-hoppers", comment="Based on Aikar's optimizationo of Hoppers, setting this to 'true'\nwill allow for hoppers to save performing server -> client updates\nwhen transferring items. Because hoppers can transfer items multiple\ntimes per tick, these updates can get costly on the server, with\nlittle to no benefit to the client. Because of the nature of the\nchange, the default will be 'false' due to the inability to pre-emptively\nforetell whether mod compatibility will fail with these changes or not.\nRefer to: https://github.com/PaperMC/Paper/blob/8175ec916f31dcd130fe0884fe46bdc187d829aa/Spigot-Server-Patches/0269-Optimize-Hoppers.patch\nfor more details.")
    private boolean optimizeHoppers = false;
    @Setting(value="use-active-chunks-for-collisions", comment="Vanilla performs a lot of is area loaded checks during\nentity collision calculations with blocks, and because\nthese calculations require fetching the chunks to see\nif they are loaded, before getting the block states\nfrom those chunks, there can be some small performance\nincrease by checking the entity's owned active chunk\nit may currently reside in. Essentially, instead of\nasking the world if those chunks are loaded, the entity\nwould know whether it's chunks are loaded and that neighbor's\nchunks are loaded.")
    private boolean useActiveChunkForCollisions = false;
    @Setting(value="disable-failing-deserialization-log-spam", comment="Occasionally, some built in advancements, \nrecipes, etc. can fail to deserialize properly\nwhich ends up potentially spamming the server log\nand the original provider of the failing content\nis not able to fix. This provides an option to\nsuppress the exceptions printing out in the log.")
    private boolean disableFailingAdvancementDeserialization = true;

    public OptimizationCategory() {
        try {
            this.preItemDropMerge = Launch.classLoader.getClassBytes("net.minecraftforge.common.ForgeVersion") == null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public StructureSaveCategory getStructureSaveCategory() {
        return this.structureSaveCategory;
    }

    public boolean useStructureSave() {
        return this.structureSaveCategory.isEnabled();
    }

    public boolean useMapOptimization() {
        return this.mapOptimization;
    }

    public boolean doDropsPreMergeItemDrops() {
        return this.preItemDropMerge;
    }

    public boolean useCacheTameableOwners() {
        return this.cacheTameableOwners;
    }

    public AsyncLightingCategory getAsyncLightingCategory() {
        return this.asyncLightingCategory;
    }

    public boolean useAsyncLighting() {
        return this.asyncLightingCategory.isEnabled();
    }

    public EigenRedstoneCategory getEigenRedstoneCategory() {
        return this.eigenRedstonCategory;
    }

    public boolean useEigenRedstone() {
        return this.eigenRedstonCategory.isEnabled();
    }

    public boolean usePandaRedstone() {
        return this.pandaRedstone;
    }

    public boolean useEnchantmentHelperFix() {
        return this.enchantmentLeak;
    }

    public boolean useFastThreadChecks() {
        return this.fasterThreadChecks;
    }

    public void setPandaRedstone(boolean pandaRedstone) {
        this.pandaRedstone = pandaRedstone;
    }

    public boolean isOptimizeHoppers() {
        return this.optimizeHoppers;
    }

    public boolean isUseActiveChunkForCollisions() {
        return this.useActiveChunkForCollisions;
    }

    public boolean disableFailingAdvancementDeserialization() {
        return this.disableFailingAdvancementDeserialization;
    }
}

