/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.util.ReflectionUtil;

public final class ImmutableDataCachingUtil {
    public static final int CACHE_LIMIT_FOR_INDIVIDUAL_TYPE = 100;
    public static final int MANIPULATOR_CACHE_LIMIT = 100000;
    public static final int VALUE_CACHE_LIMIT = 100000;
    private static final Cache<String, ImmutableDataManipulator<?, ?>> manipulatorCache = CacheBuilder.newBuilder().maximumSize(100000L).concurrencyLevel(4).build();
    private static final Cache<String, ImmutableValue<?>> valueCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(100000L).build();

    private ImmutableDataCachingUtil() {
    }

    public static <T extends ImmutableDataManipulator<?, ?>> T getManipulator(Class<T> immutableClass, Object ... args) {
        String key = ImmutableDataCachingUtil.getKey(immutableClass, args);
        try {
            return (T)((ImmutableDataManipulator)manipulatorCache.get((Object)key, () -> {
                try {
                    return (ImmutableDataManipulator)ReflectionUtil.createUnsafeInstance(immutableClass, args);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    SpongeImpl.getLogger().error("Could not construct an ImmutableDataManipulator: " + immutableClass.getCanonicalName() + " with the args: " + Arrays.toString(args), (Throwable)e);
                    throw new UnsupportedOperationException("Could not construct the ImmutableDataManipulator: " + immutableClass.getName() + " with the args: " + Arrays.toString(args));
                }
            }));
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException("Could not construct the ImmutableDataManipulator: " + immutableClass.getName(), e);
        }
    }

    public static <E, V extends ImmutableValue<?>, T extends ImmutableValue<E>> T getValue(Class<V> valueClass, Key<? extends BaseValue<E>> usedKey, E defaultArg, E arg, Object ... extraArgs) {
        String key = ImmutableDataCachingUtil.getKey(valueClass, usedKey.getQuery().asString('.'), arg.getClass(), arg);
        try {
            return (T)((ImmutableValue)valueCache.get((Object)key, () -> {
                try {
                    if (extraArgs == null || extraArgs.length == 0) {
                        return (ImmutableValue)ReflectionUtil.createUnsafeInstance(valueClass, usedKey, defaultArg, arg);
                    }
                    return (ImmutableValue)ReflectionUtil.createUnsafeInstance(valueClass, usedKey, defaultArg, arg, extraArgs);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    SpongeImpl.getLogger().error("Could not construct an ImmutableValue: " + valueClass.getCanonicalName(), (Throwable)e);
                    throw new UnsupportedOperationException("Could not construct the ImmutableValue: " + valueClass.getName());
                }
            }));
        }
        catch (ExecutionException e) {
            throw new UnsupportedOperationException("Could not construct the ImmutableValue: " + valueClass.getName(), e);
        }
    }

    private static String getKey(Class<?> immutableClass, Object ... args) {
        StringBuilder builder = new StringBuilder(immutableClass.getCanonicalName() + ":");
        for (Object object : args) {
            if (object instanceof CatalogType) {
                builder.append("{").append(((CatalogType)object).getId()).append("}");
                continue;
            }
            builder.append("{").append(object.toString()).append("}");
        }
        return builder.toString();
    }
}

