/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableDespawnDelayData;
import org.spongepowered.api.data.manipulator.mutable.entity.DespawnDelayData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeDespawnDelayData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public final class ImmutableSpongeDespawnDelayData
extends AbstractImmutableData<ImmutableDespawnDelayData, DespawnDelayData>
implements ImmutableDespawnDelayData {
    private final int value;

    public ImmutableSpongeDespawnDelayData(int value) {
        super(ImmutableDespawnDelayData.class);
        this.value = value;
        this.registerGetters();
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.INFINITE_DESPAWN_DELAY, this::isInfinite);
        this.registerKeyValue(Keys.INFINITE_DESPAWN_DELAY, this::infinite);
        this.registerFieldGetter(Keys.DESPAWN_DELAY, this::getDelay);
        this.registerKeyValue(Keys.DESPAWN_DELAY, this::delay);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.DESPAWN_DELAY, (Object)this.value).set(Keys.INFINITE_DESPAWN_DELAY, (Object)this.isInfinite());
    }

    @Override
    public ImmutableValue<Boolean> infinite() {
        return new ImmutableSpongeValue<Boolean>(Keys.INFINITE_DESPAWN_DELAY, false, this.isInfinite());
    }

    private boolean isInfinite() {
        return this.value == Short.MIN_VALUE;
    }

    @Override
    public ImmutableBoundedValue<Integer> delay() {
        return SpongeValueFactory.boundedBuilder(Keys.DESPAWN_DELAY).actualValue(this.value).minimum((Integer)Short.MIN_VALUE).maximum((Integer)Short.MAX_VALUE).defaultValue(0).build().asImmutable();
    }

    private int getDelay() {
        return this.value;
    }

    @Override
    public DespawnDelayData asMutable() {
        return new SpongeDespawnDelayData(this.value);
    }
}

