/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.entity.SpongeEntitySnapshot;
import org.spongepowered.common.util.Constants;

public class SpongeEntitySnapshotBuilder
extends AbstractDataBuilder<EntitySnapshot>
implements EntitySnapshot.Builder {
    UUID worldId;
    Vector3d position;
    Vector3d rotation;
    Vector3d scale;
    EntityType entityType;
    @Nullable
    UUID entityId;
    @Nullable
    List<ImmutableDataManipulator<?, ?>> manipulators;
    @Nullable
    NBTTagCompound compound;
    @Nullable
    List<ImmutableValue<?>> values;
    @Nullable
    WeakReference<org.spongepowered.api.entity.Entity> entityReference;

    public SpongeEntitySnapshotBuilder() {
        super(EntitySnapshot.class, 1);
    }

    @Override
    public SpongeEntitySnapshotBuilder world(WorldProperties worldProperties) {
        this.worldId = ((WorldProperties)Preconditions.checkNotNull((Object)worldProperties)).getUniqueId();
        return this;
    }

    public SpongeEntitySnapshotBuilder worldId(UUID worldUuid) {
        this.worldId = (UUID)Preconditions.checkNotNull((Object)worldUuid);
        return this;
    }

    @Override
    public SpongeEntitySnapshotBuilder type(EntityType entityType) {
        this.entityType = (EntityType)Preconditions.checkNotNull((Object)entityType);
        this.compound = null;
        this.manipulators = null;
        this.entityId = null;
        return this;
    }

    @Override
    public SpongeEntitySnapshotBuilder position(Vector3d position) {
        this.position = (Vector3d)Preconditions.checkNotNull((Object)position);
        return this;
    }

    public SpongeEntitySnapshotBuilder rotation(Vector3d rotation) {
        this.rotation = (Vector3d)Preconditions.checkNotNull((Object)rotation);
        return this;
    }

    public SpongeEntitySnapshotBuilder scale(Vector3d scale) {
        this.scale = (Vector3d)Preconditions.checkNotNull((Object)scale);
        return this;
    }

    public SpongeEntitySnapshotBuilder id(UUID entityId) {
        this.entityId = (UUID)Preconditions.checkNotNull((Object)entityId);
        return this;
    }

    @Override
    public SpongeEntitySnapshotBuilder from(org.spongepowered.api.entity.Entity entity) {
        this.reset();
        this.entityReference = new WeakReference<org.spongepowered.api.entity.Entity>(entity);
        this.worldId = entity.getWorld().getUniqueId();
        this.position = entity.getTransform().getPosition();
        this.rotation = entity.getTransform().getRotation();
        this.scale = entity.getTransform().getScale();
        this.entityType = entity.getType();
        this.entityId = entity.getUniqueId();
        this.manipulators = Lists.newArrayList();
        for (DataManipulator<?, ?> manipulator : ((CustomDataHolderBridge)((Object)entity)).bridge$getCustomManipulators()) {
            this.addManipulator((ImmutableDataManipulator<?, ?>)manipulator.asImmutable());
        }
        this.compound = new NBTTagCompound();
        ((Entity)entity).func_189511_e(this.compound);
        return this;
    }

    @Override
    public SpongeEntitySnapshotBuilder add(DataManipulator<?, ?> manipulator) {
        Preconditions.checkState((this.entityType != null ? 1 : 0) != 0, (Object)"Must have a valid entity type before applying data!");
        return this.add((ImmutableDataManipulator)manipulator.asImmutable());
    }

    @Override
    public SpongeEntitySnapshotBuilder add(ImmutableDataManipulator<?, ?> manipulator) {
        Preconditions.checkState((this.entityType != null ? 1 : 0) != 0, (Object)"Must have a valid entity type before applying data!");
        Optional optional = DataUtil.getImmutableProcessor(manipulator.getClass());
        if (optional.isPresent()) {
            if (optional.get().supports(this.entityType)) {
                this.addManipulator(manipulator);
            } else {
                return this;
            }
        }
        return this;
    }

    @Override
    public <V> EntitySnapshot.Builder add(Key<? extends BaseValue<V>> key, V value) {
        Preconditions.checkNotNull(key, (Object)"key");
        Preconditions.checkState((this.entityType != null ? 1 : 0) != 0, (Object)"Must have a valid entity type before applying data!");
        if (this.values == null) {
            this.values = Lists.newArrayList();
        }
        this.values.add(new ImmutableSpongeValue<V>(key, value));
        return this;
    }

    private void addManipulator(ImmutableDataManipulator<?, ?> manipulator) {
        if (this.manipulators == null) {
            this.manipulators = Lists.newArrayList();
        }
        int replaceIndex = -1;
        for (ImmutableDataManipulator<?, ?> existing : this.manipulators) {
            ++replaceIndex;
            if (!existing.getClass().equals(manipulator.getClass())) continue;
            break;
        }
        if (replaceIndex != -1) {
            this.manipulators.remove(replaceIndex);
        }
        this.manipulators.add(manipulator);
    }

    @Override
    public SpongeEntitySnapshotBuilder from(EntitySnapshot holder) {
        this.entityType = holder.getType();
        this.worldId = holder.getWorldUniqueId();
        if (holder.getUniqueId().isPresent()) {
            this.entityId = holder.getUniqueId().get();
        }
        this.position = holder.getPosition().toDouble();
        Optional<Transform<World>> optional = holder.getTransform();
        if (optional.isPresent()) {
            this.position = optional.get().getPosition();
            this.rotation = optional.get().getRotation();
            this.scale = optional.get().getScale();
        }
        this.manipulators = Lists.newArrayList();
        for (ImmutableDataManipulator manipulator : holder.getContainers()) {
            this.add(manipulator);
        }
        if (holder instanceof SpongeEntitySnapshot) {
            this.compound = ((SpongeEntitySnapshot)holder).getCompound().orElse(null);
        }
        return this;
    }

    @Override
    public SpongeEntitySnapshotBuilder from(Entity minecraftEntity) {
        this.entityType = ((org.spongepowered.api.entity.Entity)minecraftEntity).getType();
        this.worldId = ((org.spongepowered.api.entity.Entity)minecraftEntity).getWorld().getUniqueId();
        this.entityId = minecraftEntity.func_110124_au();
        Transform<World> transform = ((org.spongepowered.api.entity.Entity)minecraftEntity).getTransform();
        this.position = transform.getPosition();
        this.rotation = transform.getRotation();
        this.scale = transform.getScale();
        this.manipulators = Lists.newArrayList();
        for (DataManipulator<?, ?> manipulator : ((CustomDataHolderBridge)minecraftEntity).bridge$getCustomManipulators()) {
            this.addManipulator((ImmutableDataManipulator<?, ?>)manipulator.asImmutable());
        }
        this.compound = new NBTTagCompound();
        minecraftEntity.func_189511_e(this.compound);
        return this;
    }

    public SpongeEntitySnapshotBuilder unsafeCompound(NBTTagCompound compound) {
        this.compound = ((NBTTagCompound)Preconditions.checkNotNull((Object)compound)).func_74737_b();
        return this;
    }

    @Override
    public SpongeEntitySnapshotBuilder reset() {
        this.worldId = null;
        this.entityId = null;
        this.position = null;
        this.rotation = null;
        this.scale = null;
        this.entityType = null;
        this.entityId = null;
        this.manipulators = null;
        this.compound = null;
        this.entityReference = null;
        return this;
    }

    @Override
    public EntitySnapshot build() {
        Preconditions.checkNotNull((Object)this.worldId);
        Preconditions.checkNotNull((Object)this.position);
        Preconditions.checkNotNull((Object)this.rotation);
        Preconditions.checkNotNull((Object)this.scale);
        Preconditions.checkNotNull((Object)this.entityType);
        EntitySnapshot snapshot = new SpongeEntitySnapshot(this);
        if (this.values != null) {
            for (ImmutableValue<?> value : this.values) {
                snapshot = snapshot.with(value).orElse(snapshot);
            }
        }
        return snapshot;
    }

    @Override
    protected Optional<EntitySnapshot> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Queries.WORLD_ID, Constants.Entity.TYPE, Constants.Entity.ROTATION, Constants.Entity.SCALE, Constants.Sponge.SNAPSHOT_WORLD_POSITION)) {
            return Optional.empty();
        }
        this.worldId = UUID.fromString(container.getString(Queries.WORLD_ID).get());
        this.position = DataUtil.getPosition3d(container, Constants.Sponge.SNAPSHOT_WORLD_POSITION);
        this.rotation = DataUtil.getPosition3d(container, Constants.Entity.ROTATION);
        this.scale = DataUtil.getPosition3d(container, Constants.Entity.SCALE);
        String entityTypeId = container.getString(Constants.Entity.TYPE).get();
        this.entityType = SpongeImpl.getRegistry().getType(EntityType.class, entityTypeId).get();
        this.manipulators = container.contains(Constants.Sponge.DATA_MANIPULATORS) ? DataUtil.deserializeImmutableManipulatorList(container.getViewList(Constants.Sponge.DATA_MANIPULATORS).get()) : ImmutableList.of();
        if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
            this.compound = NbtTranslator.getInstance().translateData(container.getView(Constants.Sponge.UNSAFE_NBT).get());
        }
        if (container.contains(Constants.Entity.UUID)) {
            this.entityId = UUID.fromString(container.getString(Constants.Entity.UUID).get());
        }
        return Optional.of(this.build());
    }
}

