/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;
import org.spongepowered.common.world.BlockChange;

final class BlockDecayPhaseState
extends BlockPhaseState {
    private final BiConsumer<CauseStackManager.StackFrame, GeneralizedContext> BLOCK_DECAY_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        LocatableBlock locatable = context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
        frame.pushCause(locatable);
    });

    BlockDecayPhaseState() {
    }

    @Override
    public GeneralizedContext createNewContext() {
        return (GeneralizedContext)super.createNewContext().addCaptures();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, GeneralizedContext> getFrameModifier() {
        return this.BLOCK_DECAY_MODIFIER;
    }

    @Override
    public void unwind(GeneralizedContext context) {
        LocatableBlock locatable = context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
        Location<World> worldLocation = locatable.getLocation();
        WorldServerBridge mixinWorld = (WorldServerBridge)((Object)worldLocation.getExtent());
        TrackingUtil.processBlockCaptures(context);
        context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
            List<Entity> entities = items.stream().map(entity -> (Entity)entity).collect(Collectors.toList());
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            SpongeCommonEventFactory.callDropItemDestruct(entities, context);
        });
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            SpongeCommonEventFactory.callDropItemDestruct(entities, context);
        });
        context.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(drops -> {
            List<Entity> items = drops.stream().map(drop -> drop.create((WorldServer)mixinWorld)).collect(Collectors.toList());
            List<Entity> entities = items;
            if (!entities.isEmpty()) {
                SpongeCommonEventFactory.callDropItemDestruct(entities, context);
            }
        });
        context.getBlockItemDropSupplier().acceptAndClearIfNotEmpty(drops -> drops.asMap().forEach((key, value) -> {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            SpongeCommonEventFactory.callDropItemDestruct(new ArrayList<Entity>((Collection<Entity>)value), context);
        }));
    }

    @Override
    public BlockChange associateBlockChangeWithSnapshot(GeneralizedContext phaseContext, IBlockState newState, Block newBlock, IBlockState currentState, SpongeBlockSnapshot snapshot, Block originalBlock) {
        if (newBlock == Blocks.field_150350_a) {
            return BlockChange.DECAY;
        }
        return super.associateBlockChangeWithSnapshot(phaseContext, newState, newBlock, currentState, snapshot, originalBlock);
    }
}

