/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.entity.BasicEntityContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhaseState;

public class EntityDropPhaseState
extends EntityPhaseState<BasicEntityContext> {
    private final BiConsumer<CauseStackManager.StackFrame, BasicEntityContext> DEATH_STATE_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        org.spongepowered.api.entity.Entity dyingEntity = ctx.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Dying entity not found!", ctx));
        DamageSource damageSource = ctx.getDamageSource();
        frame.pushCause(dyingEntity);
        if (damageSource != null) {
            frame.pushCause(damageSource);
        }
    });

    @Override
    public boolean tracksEntityDeaths() {
        return true;
    }

    @Override
    public BasicEntityContext createNewContext() {
        return (BasicEntityContext)((BasicEntityContext)new BasicEntityContext(this).addCaptures()).addEntityDropCaptures();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicEntityContext> getFrameModifier() {
        return this.DEATH_STATE_MODIFIER;
    }

    @Override
    public void unwind(BasicEntityContext context) {
        org.spongepowered.api.entity.Entity dyingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Dying entity not found!", context));
        boolean isPlayer = dyingEntity instanceof EntityPlayer;
        EntityPlayer entityPlayer = isPlayer ? (EntityPlayer)dyingEntity : null;
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> this.standardSpawnCapturedEntities(context, (List<? extends org.spongepowered.api.entity.Entity>)entities));
        if (context.getPerEntityItemEntityDropSupplier().isEmpty() && context.getPerEntityItemDropSupplier().isEmpty()) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            ArrayList<org.spongepowered.api.entity.Entity> entities2 = new ArrayList<org.spongepowered.api.entity.Entity>();
            SpongeCommonEventFactory.callDropItemDestruct(entities2, context);
            return;
        }
        context.getPerEntityItemEntityDropSupplier().acceptAndRemoveIfPresent(dyingEntity.getUniqueId(), items -> {
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
            for (EntityItem item : items) {
                entities.add((org.spongepowered.api.entity.Entity)item);
            }
            if (isPlayer) {
                entityPlayer.field_71071_by.func_174888_l();
            }
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            SpongeCommonEventFactory.callDropItemDestruct(entities, context);
        });
        EntityDropPhaseState.processPerItemDrop(context, dyingEntity, isPlayer, entityPlayer);
    }

    static void processPerItemDrop(EntityContext<?> context, org.spongepowered.api.entity.Entity dyingEntity, boolean isPlayer, @Nullable EntityPlayer entityPlayer) {
        context.getPerEntityItemDropSupplier().acceptAndRemoveIfPresent(dyingEntity.getUniqueId(), itemStacks -> {
            ArrayList items = new ArrayList(itemStacks);
            if (!items.isEmpty()) {
                Entity minecraftEntity = (Entity)dyingEntity;
                List<org.spongepowered.api.entity.Entity> itemEntities = items.stream().map(data -> data.create((WorldServer)minecraftEntity.field_70170_p)).map(entity -> (org.spongepowered.api.entity.Entity)entity).collect(Collectors.toList());
                if (isPlayer && entityPlayer != null) {
                    entityPlayer.field_71071_by.func_174888_l();
                }
                SpongeCommonEventFactory.callDropItemDestruct(itemEntities, context);
            }
        });
    }
}

