/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.bridge.item.inventory.InventoryBridge;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.CraftingGridInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.impl.comp.CraftingGridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.slots.SlotLensImpl;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static CraftingGridInventory toSpongeInventory(InventoryCrafting inv) {
        CraftingGridInventoryLensImpl lens = new CraftingGridInventoryLensImpl(0, inv.func_174922_i(), inv.func_174923_h(), inv.func_174922_i(), SlotLensImpl::new);
        return new CraftingGridInventoryAdapter((Fabric)inv, lens);
    }

    public static InventoryCrafting toNativeInventory(CraftingGridInventory inv) {
        Fabric fabric = ((CraftingGridInventoryAdapter)inv).bridge$getFabric();
        for (InventoryBridge inventory : fabric.fabric$allInventories()) {
            if (!(inventory instanceof InventoryCrafting)) continue;
            return (InventoryCrafting)inventory;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Invalid CraftingGridInventory. Could not find InventoryCrafting.\n").append("Fabric was: ").append(fabric.getClass().getSimpleName()).append(" Name: ").append(fabric.fabric$getDisplayName() == null ? "unknown" : fabric.fabric$getDisplayName().get()).append("Viewed:");
        for (InventoryBridge iInventory : fabric.fabric$allInventories()) {
            sb.append("\n").append(iInventory.getClass().getName());
        }
        throw new IllegalStateException(sb.toString());
    }

    public static Optional<Inventory> getDoubleChestInventory(TileEntityChest chest) {
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = chest.func_174877_v().func_177972_a(enumfacing);
            TileEntity tileentity1 = chest.func_145831_w().func_175625_s(blockpos);
            if (!(tileentity1 instanceof TileEntityChest) || tileentity1.func_145838_q() != chest.func_145838_q()) continue;
            InventoryLargeChest inventory = enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH ? new InventoryLargeChest("container.chestDouble", (ILockableContainer)chest, (ILockableContainer)((TileEntityChest)tileentity1)) : new InventoryLargeChest("container.chestDouble", (ILockableContainer)((TileEntityChest)tileentity1), (ILockableContainer)chest);
            return Optional.of((Inventory)inventory);
        }
        return Optional.empty();
    }

    public static Inventory toInventory(IInventory inventory) {
        return InventoryUtil.toInventory(inventory, null);
    }

    public static Inventory toInventory(Object inventory, @Nullable Object forgeItemHandler) {
        if (forgeItemHandler == null) {
            if (inventory instanceof TileEntityChest) {
                inventory = InventoryUtil.getDoubleChestInventory((TileEntityChest)inventory).orElse((Inventory)inventory);
            }
            if (inventory instanceof Inventory) {
                return (Inventory)inventory;
            }
        }
        if (forgeItemHandler instanceof Inventory) {
            return (Inventory)forgeItemHandler;
        }
        return SpongeImplHooks.toInventory(inventory, forgeItemHandler);
    }

    public static InventoryAdapter findAdapter(Object inventory) {
        if (inventory instanceof InventoryAdapter) {
            return (InventoryAdapter)inventory;
        }
        return SpongeImplHooks.findInventoryAdapter(inventory);
    }

    public static TrackedInventoryBridge forCapture(Object toCapture) {
        if (toCapture instanceof TrackedInventoryBridge) {
            return (TrackedInventoryBridge)toCapture;
        }
        return null;
    }

    public static PluginContainer getPluginContainer(Object inventory) {
        PluginContainer container;
        Object base;
        Optional carrier;
        if (inventory instanceof CarriedInventory && (carrier = ((CarriedInventory)inventory).getCarrier()).isPresent()) {
            inventory = carrier.get();
        }
        if ((base = inventory) instanceof org.spongepowered.api.block.tileentity.TileEntity) {
            String id = ((org.spongepowered.api.block.tileentity.TileEntity)base).getBlock().getType().getId();
            String pluginId = id.substring(0, id.indexOf(":"));
            container = Sponge.getPluginManager().getPlugin(pluginId).orElseThrow(() -> new AssertionError((Object)("Missing plugin " + pluginId + " for block " + id)));
        } else if (base instanceof Entity) {
            String id = ((Entity)base).getType().getId();
            String pluginId = id.substring(0, id.indexOf(":"));
            container = Sponge.getPluginManager().getPlugin(pluginId).orElseGet(() -> {
                SpongeImpl.getLogger().debug("Unknown plugin for [{}]", base);
                return SpongeImpl.getMinecraftPlugin();
            });
        } else {
            container = base instanceof SpongeUser ? SpongeImpl.getMinecraftPlugin() : Sponge.getPluginManager().getPlugin(SpongeImplHooks.getModIdFromClass(base.getClass())).orElseGet(() -> {
                SpongeImpl.getLogger().debug("Unknown plugin for [{}]", base);
                return SpongeImpl.getMinecraftPlugin();
            });
        }
        return container;
    }
}

