/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Server;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.world.ChunkTicketManager;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.command.CommandSourceBridge;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.profile.SpongeProfileManager;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

@Mixin(value={MinecraftServer.class})
@Implements(value={@Interface(iface=CommandSource.class, prefix="command$")})
public abstract class MinecraftServerMixin_API
implements Server,
ConsoleSource {
    @Shadow
    @Final
    public Profiler field_71304_b;
    @Shadow
    @Final
    public long[] field_71311_j;
    @Shadow
    private int field_71315_w;
    @Shadow
    private String field_71286_C;
    @Shadow
    public WorldServer[] field_71305_c;
    @Shadow
    private Thread field_175590_aa;
    private GameProfileManager profileManager;
    private MessageChannel broadcastChannel = MessageChannel.TO_ALL;

    @Shadow
    public abstract void func_145747_a(ITextComponent var1);

    @Shadow
    public abstract void func_71263_m();

    @Shadow
    public abstract boolean func_71266_T();

    @Shadow
    public abstract String func_71270_I();

    @Shadow
    public abstract PlayerList func_184103_al();

    @Shadow
    public abstract EnumDifficulty func_147135_j();

    @Shadow
    public abstract GameType func_71265_f();

    @Shadow
    public abstract int func_143007_ar();

    @Shadow
    public abstract String shadow$func_70005_c_();

    @Override
    public ConsoleSource getConsole() {
        return this;
    }

    @Override
    public Optional<World> getWorld(String worldName) {
        return WorldManager.getWorld(worldName);
    }

    @Override
    public ChunkLayout getChunkLayout() {
        return SpongeChunkLayout.instance;
    }

    @Override
    public Optional<WorldProperties> getWorldProperties(String worldName) {
        return WorldManager.getWorldProperties(worldName);
    }

    @Override
    public Collection<WorldProperties> getAllWorldProperties() {
        return WorldManager.getAllWorldProperties();
    }

    @Override
    public MessageChannel getBroadcastChannel() {
        return this.broadcastChannel;
    }

    @Override
    public void setBroadcastChannel(MessageChannel channel) {
        this.broadcastChannel = (MessageChannel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
    }

    @Override
    public Optional<InetSocketAddress> getBoundAddress() {
        return Optional.empty();
    }

    @Override
    public boolean hasWhitelist() {
        return this.func_184103_al().func_72383_n();
    }

    @Override
    public void setHasWhitelist(boolean enabled) {
        this.func_184103_al().func_72371_a(enabled);
    }

    @Override
    public boolean getOnlineMode() {
        return this.func_71266_T();
    }

    @Override
    public Collection<Player> getOnlinePlayers() {
        if (this.func_184103_al() == null || this.func_184103_al().func_181057_v() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.func_184103_al().func_181057_v());
    }

    @Override
    public Optional<Player> getPlayer(UUID uniqueId) {
        if (this.func_184103_al() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Player)this.func_184103_al().func_177451_a(uniqueId));
    }

    @Override
    public Optional<Player> getPlayer(String name) {
        if (this.func_184103_al() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Player)this.func_184103_al().func_152612_a(name));
    }

    @Override
    public Text getMotd() {
        return SpongeTexts.fromLegacy(this.field_71286_C);
    }

    @Override
    public int getMaxPlayers() {
        if (this.func_184103_al() == null) {
            return 0;
        }
        return this.func_184103_al().func_72352_l();
    }

    @Override
    public int getRunningTimeTicks() {
        return this.field_71315_w;
    }

    @Override
    public double getTicksPerSecond() {
        double nanoSPerTick = MathHelper.func_76127_a((long[])this.field_71311_j);
        return 1000.0 / Math.max(50.0, nanoSPerTick / 1000000.0);
    }

    @Override
    public void shutdown() {
        this.func_71263_m();
    }

    @Override
    public void shutdown(Text kickMessage) {
        for (Player player : this.getOnlinePlayers()) {
            player.kick(kickMessage);
        }
        this.func_71263_m();
    }

    @Override
    public Optional<World> loadWorld(UUID uuid) {
        return WorldManager.loadWorld(uuid);
    }

    @Override
    public Optional<World> loadWorld(WorldProperties properties) {
        return WorldManager.loadWorld(properties);
    }

    @Override
    public Optional<World> loadWorld(String worldName) {
        return WorldManager.loadWorld(worldName);
    }

    @Override
    public WorldProperties createWorldProperties(String folderName, WorldArchetype archetype) {
        return WorldManager.createWorldProperties(folderName, archetype);
    }

    @Override
    public boolean unloadWorld(World world) {
        return ((WorldServerBridge)((Object)world)).bridge$getDimensionId() != 0 && WorldManager.unloadWorld((WorldServer)world, false, false);
    }

    @Override
    public Collection<World> getWorlds() {
        return Collections.unmodifiableCollection(WorldManager.getWorlds());
    }

    @Override
    public Optional<World> getWorld(UUID uniqueId) {
        for (WorldServer worldserver : WorldManager.getWorlds()) {
            if (!((World)worldserver).getUniqueId().equals(uniqueId)) continue;
            return Optional.of((World)worldserver);
        }
        return Optional.empty();
    }

    @Override
    public Optional<WorldProperties> getDefaultWorld() {
        return WorldManager.getWorldByDimensionId(0).map(worldServer -> ((World)worldServer).getProperties());
    }

    @Override
    public String getDefaultWorldName() {
        Preconditions.checkState((this.func_71270_I() != null ? 1 : 0) != 0, (Object)"Attempt made to grab default world name too early!");
        return this.func_71270_I();
    }

    @Override
    public Collection<WorldProperties> getUnloadedWorlds() {
        return (Collection)WorldManager.getAllWorldProperties().stream().filter(props -> !this.getWorld(props.getUniqueId()).isPresent()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Optional<WorldProperties> getWorldProperties(UUID uniqueId) {
        return WorldManager.getWorldProperties(uniqueId);
    }

    @Override
    public CompletableFuture<Optional<WorldProperties>> copyWorld(WorldProperties worldProperties, String copyName) {
        return WorldManager.copyWorld(worldProperties, copyName);
    }

    @Override
    public Optional<WorldProperties> renameWorld(WorldProperties worldProperties, String newName) {
        return WorldManager.renameWorld(worldProperties, newName);
    }

    @Override
    public CompletableFuture<Boolean> deleteWorld(WorldProperties worldProperties) {
        return WorldManager.deleteWorld(worldProperties);
    }

    @Override
    public boolean saveWorldProperties(WorldProperties properties) {
        return WorldManager.saveWorldProperties(properties);
    }

    @Override
    public ChunkTicketManager getChunkTicketManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GameProfileManager getGameProfileManager() {
        if (this.profileManager == null) {
            this.profileManager = new SpongeProfileManager();
        }
        return this.profileManager;
    }

    @Override
    public Optional<ResourcePack> getDefaultResourcePack() {
        return Optional.ofNullable(((MinecraftServerBridge)((Object)this)).bridge$getResourcePack());
    }

    @Override
    public Optional<Scoreboard> getServerScoreboard() {
        return WorldManager.getWorldByDimensionId(0).map(worldServer -> (Scoreboard)worldServer.func_96441_U());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getPlayerIdleTimeout() {
        return this.func_143007_ar();
    }

    @Override
    public boolean isMainThread() {
        return this.field_175590_aa == Thread.currentThread();
    }

    @Override
    public String getIdentifier() {
        return ((CommandSourceBridge)((Object)this)).bridge$getIdentifier();
    }

    @Intrinsic
    public String command$getName() {
        return this.shadow$func_70005_c_();
    }
}

