/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.projectile.explosive.WitherSkull;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.entity.GrieferBridge;
import org.spongepowered.common.bridge.entity.item.EntityWitherSkullBridge;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.entity.projectile.EntityFireballMixin;

@Mixin(value={EntityWitherSkull.class})
public abstract class EntityWitherSkullMixin
extends EntityFireballMixin
implements EntityWitherSkullBridge,
ExplosiveBridge {
    private int explosionRadius = 1;
    private float impl$damage = 0.0f;
    private boolean impl$damageSet = false;

    @ModifyArg(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private float onAttackEntityFrom(float amount) {
        if (this.impl$damageSet) {
            return this.impl$damage;
        }
        if (this.field_70235_a != null) {
            return 8.0f;
        }
        return 5.0f;
    }

    @Override
    public void spongeImpl$readFromSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$readFromSpongeCompound(compound);
        if (compound.func_74764_b("damageAmount")) {
            this.impl$damage = compound.func_74760_g("damageAmount");
            this.impl$damageSet = true;
        }
    }

    @Override
    public void spongeImpl$writeToSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$writeToSpongeCompound(compound);
        if (this.impl$damageSet) {
            compound.func_74776_a("damageAmount", this.impl$damage);
        } else {
            compound.func_82580_o("damageAmount");
        }
    }

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.explosionRadius);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer explosionRadius) {
        this.explosionRadius = explosionRadius == null ? 1 : explosionRadius;
    }

    @Override
    @Redirect(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;newExplosion(Lnet/minecraft/entity/Entity;DDDFZZ)Lnet/minecraft/world/Explosion;"))
    @Nullable
    public net.minecraft.world.Explosion bridge$CreateAndProcessExplosionEvent(World worldObj, Entity self, double x, double y, double z, float strength, boolean flaming, boolean smoking) {
        boolean griefer = ((GrieferBridge)((Object)this)).bridge$CanGrief();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            frame.addContext(EventContextKeys.THROWER, ((WitherSkull)((Object)this)).getShooter());
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, ((WitherSkull)((Object)this)).getShooter());
            frame.pushCause(((WitherSkull)((Object)this)).getShooter());
            net.minecraft.world.Explosion explosion = SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldObj, new Vector3d(x, y, z))).sourceExplosive((WitherSkull)((Object)this)).radius(this.explosionRadius).canCauseFire(flaming).shouldPlaySmoke(smoking && griefer).shouldBreakBlocks(smoking && griefer)).orElse(null);
            return explosion;
        }
    }
}

