/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.biome;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.world.biome.BiomeBridge;
import org.spongepowered.common.world.biome.SpongeBiomeGenerationSettings;
import org.spongepowered.common.world.gen.WorldGenConstants;

@Mixin(value={Biome.class})
public abstract class BiomeMixin
implements BiomeBridge {
    @Shadow
    public IBlockState field_76752_A;
    @Shadow
    public IBlockState field_76753_B;
    @Shadow
    public BiomeDecorator field_76760_I;
    @Nullable
    private @MonotonicNonNull String impl$id;
    @Nullable
    private @MonotonicNonNull String impl$modId;

    @Override
    public void bridge$buildPopulators(World world, SpongeBiomeGenerationSettings gensettings) {
        WorldGenConstants.buildPopulators(world, gensettings, this.field_76760_I, this.field_76752_A, this.field_76753_B);
    }

    @Inject(method={"registerBiome"}, at={@At(value="HEAD")})
    private static void onRegisterBiome(int id, String name, Biome biome, CallbackInfo ci) {
        String modId = SpongeImplHooks.getModIdFromClass(biome.getClass());
        String biomeName = name.toLowerCase().replace(" ", "_").replaceAll("[^A-Za-z0-9_]", "");
        ((BiomeBridge)biome).bridge$setModId(modId);
        ((BiomeBridge)biome).bridge$setId(modId + ":" + biomeName);
    }

    @Override
    public void bridge$setId(String id) {
        Preconditions.checkState((this.impl$id == null ? 1 : 0) != 0, (Object)"Attempt made to set ID!");
        this.impl$id = id;
    }

    @Override
    public String bridge$getId() {
        return (String)Preconditions.checkNotNull((Object)this.impl$id, (Object)"BiomeType id is null");
    }

    @Override
    public String bridge$getModId() {
        return this.impl$modId;
    }

    @Override
    public void bridge$setModId(String modId) {
        Preconditions.checkState((this.impl$modId == null || "unknown".equals(this.impl$modId) ? 1 : 0) != 0, (Object)"Attempt made to set Mod ID!");
        this.impl$modId = modId;
    }
}

