/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.mixin.plugin.RedstoneWireTurbo;

@Mixin(value={BlockRedstoneWire.class}, priority=1001)
public abstract class BlockRedstoneWireMixin_Eigen
extends Block {
    @Shadow
    @Final
    private Set<BlockPos> field_150179_b;
    @Shadow
    private boolean field_150181_a;
    private boolean old_search = SpongeImpl.getGlobalConfigAdapter().getConfig().getOptimizations().getEigenRedstoneCategory().vanillaSearch();
    private boolean old_decrement = SpongeImpl.getGlobalConfigAdapter().getConfig().getOptimizations().getEigenRedstoneCategory().vanillaDecrement();
    private RedstoneWireTurbo turbo = new RedstoneWireTurbo((BlockRedstoneWire)this);

    @Shadow
    protected abstract int func_176342_a(World var1, BlockPos var2, int var3);

    protected BlockRedstoneWireMixin_Eigen(Material materialIn) {
        super(materialIn);
    }

    @Inject(method={"updateSurroundingRedstone"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateSurroundingRedstone(World worldIn, BlockPos pos, IBlockState state, CallbackInfoReturnable<IBlockState> cir) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos, state, null);
            cir.setReturnValue(state);
        }
    }

    @Overwrite
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (this.func_176196_c(worldIn, pos)) {
                this.updateSurroundingRedstone(worldIn, pos, state, fromPos);
            } else {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    private IBlockState updateSurroundingRedstone(World worldIn, BlockPos pos, IBlockState state, BlockPos source) {
        if (this.old_search) {
            state = this.func_176345_a(worldIn, pos, pos, state);
            ArrayList list = Lists.newArrayList(this.field_150179_b);
            this.field_150179_b.clear();
            for (BlockPos blockpos : list) {
                worldIn.func_175685_c(blockpos, (Block)this, false);
            }
            return state;
        }
        return this.turbo.updateSurroundingRedstone(worldIn, pos, state, source);
    }

    @Overwrite
    private IBlockState func_176345_a(World worldIn, BlockPos pos1, BlockPos pos2, IBlockState state) {
        IBlockState iblockstate = state;
        int i = (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
        int j = 0;
        j = this.func_176342_a(worldIn, pos2, j);
        this.field_150181_a = false;
        int k = worldIn.func_175687_A(pos1);
        this.field_150181_a = true;
        if (this.old_decrement && k > 0 && k > j - 1) {
            j = k;
        }
        int l = 0;
        if (this.old_search || k < 15) {
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                boolean flag;
                BlockPos blockpos = pos1.func_177972_a(enumfacing);
                boolean bl = flag = blockpos.func_177958_n() != pos2.func_177958_n() || blockpos.func_177952_p() != pos2.func_177952_p();
                if (flag) {
                    l = this.func_176342_a(worldIn, blockpos, l);
                }
                if (worldIn.func_180495_p(blockpos).func_185915_l() && !worldIn.func_180495_p(pos1.func_177984_a()).func_185915_l()) {
                    if (!flag || pos1.func_177956_o() < pos2.func_177956_o()) continue;
                    l = this.func_176342_a(worldIn, blockpos.func_177984_a(), l);
                    continue;
                }
                if (worldIn.func_180495_p(blockpos).func_185915_l() || !flag || pos1.func_177956_o() > pos2.func_177956_o()) continue;
                l = this.func_176342_a(worldIn, blockpos.func_177977_b(), l);
            }
        }
        if (this.old_decrement) {
            j = l > j ? l - 1 : (j > 0 ? --j : 0);
            if (k > j - 1) {
                j = k;
            }
        } else {
            j = l - 1;
            if (k > j) {
                j = k;
            }
        }
        if (i != j) {
            state = state.func_177226_a((IProperty)BlockRedstoneWire.field_176351_O, (Comparable)Integer.valueOf(j));
            if (worldIn.func_180495_p(pos1) == iblockstate) {
                worldIn.func_180501_a(pos1, state, 2);
            }
            if (this.old_search) {
                this.field_150179_b.add(pos1);
                for (EnumFacing enumfacing1 : EnumFacing.values()) {
                    this.field_150179_b.add(pos1.func_177972_a(enumfacing1));
                }
            }
        }
        return state;
    }
}

