/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin.entityactivation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityWeatherEffect;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.explosive.FusedExplosive;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.EntityActivationModCategory;
import org.spongepowered.common.config.category.EntityActivationRangeCategory;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.mixin.core.entity.EntityAccessor;
import org.spongepowered.common.mixin.core.entity.EntityLivingBaseAccessor;
import org.spongepowered.common.mixin.entityactivation.util.math.AxisAlignedBBAccessor_EntityActivation;
import org.spongepowered.common.mixin.plugin.entityactivation.interfaces.ActivationCapability;

public class EntityActivationRange {
    private static final ImmutableMap<Byte, String> activationTypeMappings = new ImmutableMap.Builder().put((Object)1, (Object)"monster").put((Object)2, (Object)"creature").put((Object)3, (Object)"aquatic").put((Object)4, (Object)"ambient").put((Object)5, (Object)"misc").build();
    static AxisAlignedBB maxBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB miscBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB creatureBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB monsterBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB aquaticBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB ambientBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB tileEntityBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static Map<Byte, Integer> maxActivationRanges = Maps.newHashMap();

    public static byte initializeEntityActivationType(net.minecraft.entity.Entity entity) {
        if ((IMob.class.isAssignableFrom(entity.getClass()) || IRangedAttackMob.class.isAssignableFrom(entity.getClass())) && entity.getClass() != EntityMob.class || SpongeImplHooks.isCreatureOfType(entity, EnumCreatureType.MONSTER)) {
            return 1;
        }
        if (SpongeImplHooks.isCreatureOfType(entity, EnumCreatureType.CREATURE)) {
            return 2;
        }
        if (SpongeImplHooks.isCreatureOfType(entity, EnumCreatureType.WATER_CREATURE)) {
            return 3;
        }
        if (SpongeImplHooks.isCreatureOfType(entity, EnumCreatureType.AMBIENT)) {
            return 4;
        }
        return 5;
    }

    public static void initializeEntityActivationState(net.minecraft.entity.Entity entity) {
        ActivationCapability spongeEntity = (ActivationCapability)entity;
        if (((WorldBridge)entity.field_70170_p).bridge$isFake()) {
            return;
        }
        if (entity instanceof EntityPlayer && !SpongeImplHooks.isFakePlayer(entity) || entity instanceof EntityThrowable || entity instanceof EntityDragon || entity instanceof MultiPartEntityPart || entity instanceof EntityWither || entity instanceof EntityFireball || entity instanceof EntityWeatherEffect || entity instanceof EntityTNTPrimed || entity instanceof EntityEnderCrystal || entity instanceof EntityFireworkRocket || entity instanceof EntityFallingBlock) {
            return;
        }
        EntityActivationRangeCategory config = ((WorldInfoBridge)entity.field_70170_p.func_72912_H()).bridge$getConfigAdapter().getConfig().getEntityActivationRange();
        EntityType type = ((Entity)entity).getType();
        if (type == EntityTypes.UNKNOWN || !(type instanceof SpongeEntityType)) {
            spongeEntity.activation$setDefaultActivationState(true);
            return;
        }
        SpongeEntityType spongeType = (SpongeEntityType)type;
        byte activationType = spongeEntity.activation$getActivationType();
        if (!spongeType.isActivationRangeInitialized()) {
            EntityActivationRange.addEntityToConfig(entity.field_70170_p, spongeType, activationType);
            spongeType.setActivationRangeInitialized(true);
        }
        EntityActivationModCategory entityMod = config.getModList().get(spongeType.getModId().toLowerCase());
        int defaultActivationRange = config.getDefaultRanges().get(activationTypeMappings.get((Object)activationType));
        if (entityMod == null) {
            spongeEntity.activation$setActivationRange(defaultActivationRange);
            if (defaultActivationRange > 0) {
                spongeEntity.activation$setDefaultActivationState(false);
            }
        } else {
            if (!entityMod.isEnabled()) {
                spongeEntity.activation$setDefaultActivationState(true);
                return;
            }
            Integer defaultModActivationRange = entityMod.getDefaultRanges().get(activationTypeMappings.get((Object)activationType));
            Integer entityActivationRange = entityMod.getEntityList().get(type.getName().toLowerCase());
            if (defaultModActivationRange != null && entityActivationRange == null) {
                spongeEntity.activation$setActivationRange(defaultModActivationRange);
                if (defaultModActivationRange > 0) {
                    spongeEntity.activation$setDefaultActivationState(false);
                }
            } else if (entityActivationRange != null) {
                spongeEntity.activation$setActivationRange(entityActivationRange);
                if (entityActivationRange > 0) {
                    spongeEntity.activation$setDefaultActivationState(false);
                }
            }
        }
    }

    public static void growBb(AxisAlignedBB target, AxisAlignedBB source, int x, int y, int z) {
        ((AxisAlignedBBAccessor_EntityActivation)target).accessor$setMinX(source.field_72340_a - (double)x);
        ((AxisAlignedBBAccessor_EntityActivation)target).accessor$setMinY(source.field_72338_b - (double)y);
        ((AxisAlignedBBAccessor_EntityActivation)target).accessor$setMinZ(source.field_72339_c - (double)z);
        ((AxisAlignedBBAccessor_EntityActivation)target).accessor$setMaxX(source.field_72336_d + (double)x);
        ((AxisAlignedBBAccessor_EntityActivation)target).accessor$setMaxY(source.field_72337_e + (double)y);
        ((AxisAlignedBBAccessor_EntityActivation)target).accessor$setMaxZ(source.field_72334_f + (double)z);
    }

    public static void activateEntities(net.minecraft.world.World world) {
        if (((WorldBridge)world).bridge$isFake()) {
            return;
        }
        for (EntityPlayer player : world.field_73010_i) {
            int maxRange = 0;
            for (Integer range : maxActivationRanges.values()) {
                if (range <= maxRange) continue;
                maxRange = range;
            }
            maxRange = Math.min((((World)world).getViewDistance() << 4) - 8, maxRange);
            ((ActivationCapability)player).activation$setActivatedTick(SpongeImpl.getServer().func_71259_af());
            EntityActivationRange.growBb(maxBB, player.func_174813_aQ(), maxRange, 256, maxRange);
            int i = MathHelper.func_76128_c((double)(EntityActivationRange.maxBB.field_72340_a / 16.0));
            int j = MathHelper.func_76128_c((double)(EntityActivationRange.maxBB.field_72336_d / 16.0));
            int k = MathHelper.func_76128_c((double)(EntityActivationRange.maxBB.field_72339_c / 16.0));
            int l = MathHelper.func_76128_c((double)(EntityActivationRange.maxBB.field_72334_f / 16.0));
            for (int i1 = i; i1 <= j; ++i1) {
                for (int j1 = k; j1 <= l; ++j1) {
                    WorldServer worldserver = (WorldServer)world;
                    Chunk chunk = ((ChunkProviderBridge)worldserver.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(i1, j1);
                    if (chunk == null) continue;
                    EntityActivationRange.activateChunkEntities(player, chunk);
                }
            }
        }
    }

    private static void activateChunkEntities(EntityPlayer player, Chunk chunk) {
        for (int i = 0; i < chunk.func_177429_s().length; ++i) {
            block7: for (Object o : chunk.func_177429_s()[i]) {
                net.minecraft.entity.Entity entity = (net.minecraft.entity.Entity)o;
                EntityType type = ((Entity)entity).getType();
                ActivationCapability spongeEntity = (ActivationCapability)entity;
                long currentTick = SpongeImpl.getServer().func_71259_af();
                if (!((EntityBridge)entity).bridge$shouldTick()) continue;
                if (type == EntityTypes.UNKNOWN) {
                    spongeEntity.activation$setActivatedTick(currentTick);
                    continue;
                }
                if (currentTick <= spongeEntity.activation$getActivatedTick()) continue;
                if (spongeEntity.activation$getDefaultActivationState()) {
                    spongeEntity.activation$setActivatedTick(currentTick);
                    continue;
                }
                if (spongeEntity.activation$requiresActivationCacheRefresh()) {
                    EntityActivationRange.initializeEntityActivationState(entity);
                    spongeEntity.activation$requiresActivationCacheRefresh(false);
                }
                byte activationType = spongeEntity.activation$getActivationType();
                int bbActivationRange = spongeEntity.activation$getActivationRange();
                if (activationType == 5) {
                    EntityActivationRange.growBb(miscBB, player.func_174813_aQ(), bbActivationRange, 256, bbActivationRange);
                } else if (activationType == 4) {
                    EntityActivationRange.growBb(ambientBB, player.func_174813_aQ(), bbActivationRange, 256, bbActivationRange);
                } else if (activationType == 3) {
                    EntityActivationRange.growBb(aquaticBB, player.func_174813_aQ(), bbActivationRange, 256, bbActivationRange);
                } else if (activationType == 2) {
                    EntityActivationRange.growBb(creatureBB, player.func_174813_aQ(), bbActivationRange, 256, bbActivationRange);
                } else {
                    EntityActivationRange.growBb(monsterBB, player.func_174813_aQ(), bbActivationRange, 256, bbActivationRange);
                }
                switch (spongeEntity.activation$getActivationType()) {
                    case 1: {
                        if (!monsterBB.func_72326_a(entity.func_174813_aQ())) continue block7;
                        spongeEntity.activation$setActivatedTick(currentTick);
                        continue block7;
                    }
                    case 2: {
                        if (!creatureBB.func_72326_a(entity.func_174813_aQ())) continue block7;
                        spongeEntity.activation$setActivatedTick(currentTick);
                        continue block7;
                    }
                    case 3: {
                        if (!aquaticBB.func_72326_a(entity.func_174813_aQ())) continue block7;
                        spongeEntity.activation$setActivatedTick(currentTick);
                        continue block7;
                    }
                    case 4: {
                        if (!ambientBB.func_72326_a(entity.func_174813_aQ())) continue block7;
                        spongeEntity.activation$setActivatedTick(currentTick);
                        continue block7;
                    }
                }
                if (!miscBB.func_72326_a(entity.func_174813_aQ())) continue;
                spongeEntity.activation$setActivatedTick(currentTick);
            }
        }
    }

    public static boolean checkEntityImmunities(net.minecraft.entity.Entity entity) {
        if (((EntityAccessor)entity).accessor$getFire() > 0) {
            return true;
        }
        if (!(entity instanceof Projectile) ? !entity.func_184188_bt().isEmpty() || entity.func_184187_bx() != null : !((Projectile)entity).isOnGround()) {
            return true;
        }
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (living.field_70737_aN > 0 || living.func_70651_bq().size() > 0) {
                return true;
            }
            if (entity instanceof EntityLiving && (((EntityLivingBaseAccessor)entity).accessor$getRevengeTarget() != null || ((EntityLiving)entity).func_70638_az() != null)) {
                return true;
            }
            if (entity instanceof EntityVillager && ((EntityVillager)entity).func_70941_o()) {
                return true;
            }
            if (entity instanceof EntityAnimal) {
                EntityAnimal animal = (EntityAnimal)entity;
                if (animal.func_70631_g_() || animal.func_70880_s()) {
                    return true;
                }
                if (entity instanceof EntitySheep && ((EntitySheep)entity).func_70892_o()) {
                    return true;
                }
            }
            if (entity instanceof FusedExplosive && ((FusedExplosive)entity).isPrimed()) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkIfActive(net.minecraft.entity.Entity entity) {
        boolean isActive;
        if (entity instanceof EntityPlayer || entity.field_70170_p.field_72995_K || !entity.field_70175_ag || entity instanceof EntityFireworkRocket) {
            return true;
        }
        ChunkBridge activeChunk = ((ActiveChunkReferantBridge)entity).bridge$getActiveChunk();
        if (activeChunk == null) {
            return true;
        }
        if (!activeChunk.bridge$isActive()) {
            return false;
        }
        if (activeChunk.bridge$isPersistedChunk() || !SpongeImplHooks.isFakePlayer(entity) && entity instanceof EntityPlayerMP) {
            return true;
        }
        long currentTick = SpongeImpl.getServer().func_71259_af();
        ActivationCapability spongeEntity = (ActivationCapability)entity;
        boolean bl = isActive = spongeEntity.activation$getActivatedTick() >= currentTick || spongeEntity.activation$getDefaultActivationState();
        if (!isActive) {
            if ((currentTick - spongeEntity.activation$getActivatedTick() - 1L) % 20L == 0L) {
                if (EntityActivationRange.checkEntityImmunities(entity)) {
                    spongeEntity.activation$setActivatedTick(currentTick + 20L);
                }
                isActive = true;
            }
        } else if (!spongeEntity.activation$getDefaultActivationState() && entity.field_70173_aa % 4 == 0 && !EntityActivationRange.checkEntityImmunities(entity)) {
            isActive = false;
        }
        if (isActive && !activeChunk.bridge$areNeighborsLoaded()) {
            isActive = false;
        }
        return isActive;
    }

    public static void addEntityToConfig(net.minecraft.world.World world, SpongeEntityType type, byte activationType) {
        Integer maxRange;
        Preconditions.checkNotNull((Object)world, (Object)"world");
        Preconditions.checkNotNull((Object)type, (Object)"type");
        SpongeConfig<WorldConfig> worldConfigAdapter = ((WorldInfoBridge)world.func_72912_H()).bridge$getConfigAdapter();
        SpongeConfig<GlobalConfig> globalConfigAdapter = SpongeImpl.getGlobalConfigAdapter();
        boolean autoPopulate = worldConfigAdapter.getConfig().getEntityActivationRange().autoPopulateData();
        boolean requiresSave = false;
        String entityType = "misc";
        entityType = (String)activationTypeMappings.get((Object)activationType);
        String entityModId = type.getModId().toLowerCase();
        String entityId = type.getName().toLowerCase();
        EntityActivationRangeCategory activationCategory = globalConfigAdapter.getConfig().getEntityActivationRange();
        EntityActivationModCategory entityMod = activationCategory.getModList().get(entityModId);
        Integer defaultActivationRange = activationCategory.getDefaultRanges().get(entityType);
        if (defaultActivationRange == null) {
            defaultActivationRange = 32;
        }
        Integer activationRange = activationCategory.getDefaultRanges().get(entityType);
        if (autoPopulate && entityMod == null) {
            entityMod = new EntityActivationModCategory();
            activationCategory.getModList().put(entityModId, entityMod);
            requiresSave = true;
        }
        if (entityMod != null) {
            Integer modActivationRange = entityMod.getDefaultRanges().get(entityType);
            if (autoPopulate && modActivationRange == null) {
                entityMod.getDefaultRanges().put(entityType, defaultActivationRange);
                requiresSave = true;
            } else if (modActivationRange != null && modActivationRange > activationRange) {
                activationRange = modActivationRange;
            }
            Integer entityActivationRange = entityMod.getEntityList().get(entityId);
            if (autoPopulate && entityActivationRange == null) {
                entityMod.getEntityList().put(entityId, entityMod.getDefaultRanges().get(entityType));
                requiresSave = true;
            }
            if (entityActivationRange != null && entityActivationRange > activationRange) {
                activationRange = entityActivationRange;
            }
        }
        if ((maxRange = maxActivationRanges.get(activationType)) == null) {
            maxActivationRanges.put(activationType, activationRange);
        } else if (activationRange > maxRange) {
            maxActivationRanges.put(activationType, activationRange);
        }
        if (autoPopulate && requiresSave) {
            globalConfigAdapter.save();
        }
    }
}

